﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace WpfApplication1
{
    /// <summary>
    /// Interaction logic for GlavniProzor.xaml
    /// </summary>
    public partial class GlavniProzor : Window
    {
        Konobar konobar = null;
        ImiCaffeDataContext imiCaffeDC;
        List<StavkaRacuna> stavkeRacuna;
        public GlavniProzor()
        {
            InitializeComponent();

            Login loginProzor = new Login();
            loginProzor.ShowDialog();

            if (loginProzor.konobar != null)
            {
                konobar = loginProzor.konobar;
                lbl_ImeKonobara.Content = "Konobar : " + konobar.Username;

                imiCaffeDC = new ImiCaffeDataContext();
                stavkeRacuna = new List<StavkaRacuna>();

                cb_TipArtikla.ItemsSource = imiCaffeDC.TipArtiklas;
          
                cb_TipArtikla.SelectedIndex = 0;


            }
            else
                Close();

        }

        private void cb_TipArtikla_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            TipArtikla tipArtikla = (TipArtikla)cb_TipArtikla.SelectedItem;

            var artikli = from artikal in imiCaffeDC.Artikals
                          where artikal.IDTipa == tipArtikla.ID
                          select artikal;

            cb_SpisakArtikala.ItemsSource = artikli;

            cb_SpisakArtikala.SelectedIndex = 0;
        }

        private void btn_DodajStavku_Click(object sender, RoutedEventArgs e)
        {
            Artikal artikal = (Artikal)cb_SpisakArtikala.SelectedItem;

            StavkaRacuna stavkaRacuna = new StavkaRacuna();
            stavkaRacuna.Artikal = artikal;
            stavkaRacuna.Kolicina = int.Parse(tb_Kolicina.Text);

            stavkeRacuna.Add(stavkaRacuna);

            var stavke = from st in stavkeRacuna
                                   select new
                                   {
                                       naziv = st.Artikal.NazivArtikla,
                                       kolicina = st.Kolicina,
                                       cena = st.Artikal.Cena,
                                       ukupno = st.Kolicina * st.Artikal.Cena
                                   };

            listView.ItemsSource = stavke;

            lbl_UkunapRacun.Content = stavkeRacuna.Sum(st => st.Kolicina * st.Artikal.Cena); //stavke.Sum(s => s.ukupno);

        }

        private void button_Click(object sender, RoutedEventArgs e)
        {
            Racun r = new Racun();
            //r.Konobar = konobar;
            r.IDKonobara = konobar.ID;
            r.DatumIzdavanja = DateTime.Now;
            r.StavkaRacunas.AddRange(stavkeRacuna);

            imiCaffeDC.Racuns.InsertOnSubmit(r);
            imiCaffeDC.SubmitChanges();

            listView.ItemsSource = null;
            stavkeRacuna.Clear();
            lbl_UkunapRacun.Content = "Ukupno: 0 din.";
        }

        private void MenuItem_Click(object sender, RoutedEventArgs e)
        {
            MessageBox.Show("IMI Caffe \n konobar : " + konobar.Username);
        }

        private void MenuItem_Click_1(object sender, RoutedEventArgs e)
        {
            listView.ItemsSource = null;
            stavkeRacuna.Clear();
            lbl_UkunapRacun.Content = "Ukupno: 0 din.";
        }

        private void MenuItem_Click_2(object sender, RoutedEventArgs e)
        {
            new Prikaz().ShowDialog();
        }
    }
}
