﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace WpfApplication1
{
    /// <summary>
    /// Interaction logic for Prikaz.xaml
    /// </summary>
    public partial class Prikaz : Window
    {
        ImiCaffeDataContext imiDC;
        public Prikaz()
        {
            InitializeComponent();
            imiDC = new ImiCaffeDataContext();

            osveziTabelu();
        }

        private void DatePicker_SelectedDateChanged(object sender, SelectionChangedEventArgs e)
        {


            osveziTabelu();

        }

        public void osveziTabelu()
        {
            DateTime dt = default(DateTime); 
            
            if(datum.SelectedDate.HasValue)
                dt = datum.SelectedDate.Value;

            var prikaz = from r in imiDC.Racuns
                         where r.DatumIzdavanja == dt
                         select new
                         {
                             konobar = r.Konobar.Username,
                             datum = r.DatumIzdavanja.ToString(),
                             cena = r.StavkaRacunas.Sum(sr => sr.Kolicina * sr.Artikal.Cena)
                         };

            listView.ItemsSource = prikaz;

            lbl_ukupno.Content = prikaz.Count() == 0 ? "0 din" :  prikaz.Sum(s => s.cena) + "";
        }
    }
}
