use online_igra
go
-- Kreirati sve procedure, nakon toga izvrsiti procenu troskova za izvrsavanje svake procedure, 
-- pokretanje svih procedura je dato na dnu. Sacuvati execution plan i ispisati koliko kosta pokretanje
-- svake od procedura i zbirni trosak.

-- sp_novi_potez = 3.0026
-- sp_stanje_partije = 4.99
-- sp_rang_lista = 4.2
-- sp_chat = 3.22
-- sp_broj_igraca = 0.26
-- ukupno = 3.0026 + 4.99 + 4.2 + 3.22 + 0.26 = 15.6726

--Najvise vremena odlazi na racunanje max(rbr_poteza_u_partiji), pa mozemo kreirati neklasterovani indeks na rbr_poteza_u_partiji

create nonclustered index ncl_po_rbr
on potezi (rbr_poteza_u_partiji)

--Sa ovim neklasterovanim indeksom smo smanjili vreme izvrsavanja na 0.4366 , vreme izvrsavanja ostalih procedura se nije promenilo
--Sledece gde odlazi najvise vremena sada je prvi select upit jer vrsi index scan, odnosno mora pristupati podacima u skladistu.
--Mozemo postaviti noncl. indeks na idIgraca, posto je to prvi uslov u where klauzuli 

create nonclustered index ncl_ip_idI
on igrac_partija (idIgraca)

drop index igrac_partija.ncl_ip_idI

--Ubrzali smo jos vise ovaj upit, zato sto imamo sada index seek (citanje podataka iz indeksa) i key lookup (pristup tabeli iz ncl indeksa)
-- pa to uzima manje vremena nego index scan gde se mora prolaziti kroz svaki podatak iz skladista. Nakon toga ide nested loops da bi
-- proverio da li idPartije odgovara unetom.
--Sa ovim ncl indeksom procedura traje 0.0406, vreme za ostale se nije promenilo

create nonclustered index ncl_ip_idP
on igrac_partija (idPartije)

drop index igrac_partija.ncl_ip_idP

--Moze i sa ncl na idPartije umesto na idIgraca i tada iznosi 0.0398 i poboljsava se sp_stanje_partije na 4.54 i sp_chat na 2.77

create nonclustered index ncl_ip_idP_idI
on igrac_partija (idPartije, idIgraca)

--Ovo je najbrze zato sto nema key lookup-a koji je postojao malopre, sve je u indeksu. Ovo ubrzava proceduru na 0.0298,
-- poboljsava i sp_stanje_partije na 4.53, sp_rang_lista na 1.23,  sp_chat na 2.76 dok na sp_broj_igraca ne utice
--Moze se kreirati i kompozitni klasterovani indeks nad ovim kolonama ali to ce povecati memoriju a dace iste rezultate kao i ncl
--pa je bolje izabrati ncl

create procedure sp_novi_potez
(
	@idIgraca int, @idPartije int, @potez varchar(50), @brPoena int
)
as
begin
	declare @id int, @max_rbr int, @max_id int

	select @id = id
	from igrac_partija
	where idIgraca=@idIgraca
	and idPartije=@idPartije

	select @max_rbr = max(rbr_poteza_u_partiji)
	from potezi

	select @max_id = max(id)
	from potezi

	insert into potezi(id,idIgracPartija,potez,brDobijenihPoena,rbr_poteza_u_partiji)
	values(@max_id+1,@id,@potez,@brPoena,@max_rbr+1)
end
go

exec sp_novi_potez 23158, 30000, 'Novi potez', 3


--Najvise vremena odlazi na citanje po.idIgracPartija i po.brDobijenihPoena (index scan cita iz tabele) i na hash match
--Mozemo da postavimo ncl na po.idIgracPartija da bi se to citalo iz indeksa a ne iz skladista

create nonclustered index ncl_po_idIP
on potezi (idIgracPartija)

--Dosta brze, sa 4.53 spusteno na 0.074, nema index scan-a vec je sada index seek za citanje po.idIgracPartija (cita se direktno iz ncl indeksa)
--kasnije se radi grupisanje i na samom kraju key lookup za po.brDobijenihPoena i sortiranje
--groupby sa ncl indeksom na ip.idIgraca prakticno i imamo jer imamo kompozitni ncl nad idPartije, idIgraca koji smo
--malopre postavili, a on nam odgovara i za where, a zatim i group by klauzulu. Redosled izvrsavanja
-- operacija je where pa group by, sto znaci da nam odgovara da podaci budu sortirani po idPartije a zatim po idIgraca
--bas kako je i u ncl_ip_idP_idI
--Ostalo je jos da se resi key lookup pri citanju brDobijenihPoena, a ujedno bi moglao da se ubrza
-- join tako da podaci budu sortirani po po.idIgracPartija a kako nam iz tabele potezi treba samo idIgracPartija i 
-- brDobijenihPoena, mozemo da koristimo ncl na idIgracPartija i include brDobijenihPoena
--Uklanjamo ncl indeks koji smo malopre postavili na brDobijenihPoena i dodajemo ovaj sa include,
--ne bi trebalo da poremetimo prethodnu proceduru zato sto ce ostati isti efekat da ne mora da se pristupa
--skladistu vec ce se ta vrednost ucitati iz indeksa

create nonclustered index ncl_po_idIP_incl_brPoena
on potezi (idIgracPartija) include (brDobijenihPoena)

--Sa ovim smo izbegli key lookup i jos jedan nested loops, tako da se sada procedura izvrsava za 0.024
--Sadasnje stanje
-- sp_novi_potez = 0.0399
-- sp_stanje_partije = 0.0247
-- sp_rang_lista = 1.23
-- sp_chat = 2.76
-- sp_broj_igraca = 0.26

create procedure sp_stanje_partije
(
	@idPartije int
)
as
begin
	select ip.idIgraca, sum(po.brDobijenihPoena) as poeni
	from potezi po join igrac_partija ip
	on po.idIgracPartija = ip.id
	where ip.idPartije = @idPartije
	group by ip.idIgraca
	order by poeni
end
go

exec sp_stanje_partije 100
go

--Najveci problem u execution planu pre nego sto smo postavili bilo koji indeks
-- su pravila ova dva joina i dva hash match-a koji su se vrsila. Sa PK-om nad igracima i kompozitnim
--ncl-om na idPartije, moze se primetiti da nema vise hash match-a prilikom join-a koji se vrsi
--izmedju igrac_partija i partije i tu se koristi PK i kreirani kompozitni ncl(idPartije,idIgraca)
-- nakon toga se vrsi hash match da bi se pronasao odgovarajuci pobednik(where klauzula)
-- sortiranje i nested loops 
--Ako uzmemo u obzir do sada kreirane indekse i redosled izvrsavanja operacija,
--deluje da ne moze da se postigne znacajnije ubrzanje jos nekim indeksom

create procedure sp_rang_lista
as
begin
	select top 50 i.id, i.username, count(*) as pobede
	from igraci i join igrac_partija ip
	on i.id = ip.idIgraca
	join partije par
	on ip.idPartije = par.id
	where i.id = par.pobednik
	group by i.id, i.username
	order by pobede desc
end
go

exec sp_rang_lista
go

--S obzirom na prethodno postavljene indekse na igraci (PK) i igrac_partija (kompozitni ncl), join
--ove 2 tabele ne moze da se ubrza vise, medjutim moze da se ubrza kada se chat spaja sa igrac_partija
--Trenutno izvrsavanje kosta 2.76, s obzirom da na char-u nema indeksa, mozemo postaviti ncl
--na c.idIgracPartija i posto nam u select-u treba vremePoruuke i tekstPoruke mozemo da ukljucimo i to

create nonclustered index ncl_idIP_inc_vrP_txtP
on chat(idIgracPartija) include(vremePoruke, tekstPoruke)

drop index chat.ncl_idIP_inc_vrP_txtP

--Ubrzano na 0.034, medjutim s obzirom da imamo vec 2 polja dodatno ukljucena u ovaj ncl indeks, to moze
--negativno da utice na memoriju

exec sp_spaceused chat

--index size je oko 11000KB sto je bas dosta. S obzirom da se chat ne koristi nigde osim u ovoj proceduri, njegov
--PK nam prakticno ni ne treba u tom oblilku. Bolje bi bilo da kreiramo cl indeks nad idIgracPoruka
--time cemo dobiti pristup i ostalim podacima dirketno iz indeksa i sigurno ustedeti memoriju

alter table chat
drop constraint PK_c_id

alter table chat
add constraint PK_c_id_ncl
primary key nonclustered(id)

create clustered index cl_c_idIP
on chat (idIgracPartija)

--Dobili smo isti efekat sto se tice brzine jer sada imamo nested loops na oba mesta i upit se izvrsava
--kao i malopre sa ncl include indeksom za 0.034 i memoriju koja je zauzeta smo smanjili na 5528KB,
--pa je ovakav cl indeks bolji nego ncl sa include

create procedure sp_chat
(
	@idPartije int
)
as
begin
	select i.username, c.vremePoruke, c.tekstPoruke
	from chat c join igrac_partija ip
	on c.idIgracPartija = ip.id
	join igraci i
	on ip.idIgraca = i.id
	where ip.idPartije = @idPartije 
	order by c.vremePoruke
end
go

exec sp_chat 3000
go

--Tabela igraci ima cl indeks, odnosno PK, medjutim pretraga po cl indeksu je spora zato sto se na
--nivou listova nalaze fizicki podaci pa je samim tim pretraga sporija. Bolje resenje bi bilo da se na id-u
--kreira i ncl indeks, time bi se ubrzala pretraga jer bi se pretrazivalo kroz ncl, a ne kroz cl indeks

create nonclustered index ncl_i_id
on igraci (id)

--Zaista se i postize ubrzanje, sada se procedura izvrsava za 0.0817

create procedure sp_broj_igraca
as
begin
	select count(*)
	from igraci
end

exec sp_broj_igraca


--Nakon svih postavljenih indeksa postize se sledece ubrzanje:
-- sp_novi_potez = 0.0399
-- sp_stanje_partije = 0.0247
-- sp_rang_lista = 1.189 -> ubrzao ga ncl nad igraci.id jer ga koristi za trazenje id-a
-- sp_chat = 0.0348
-- sp_broj_igraca = 0.081

--ukupno ubrzanje = 0.0399 + 0.0247 + 1.189 + 0.0348 + 0.081 = 1.369

exec sp_spaceused chat
exec sp_spaceused igrac_partija
exec sp_spaceused igraci
exec sp_spaceused partije
exec sp_spaceused potezi

--Nije lose napisati i memoriju za indeks

exec sp_novi_potez 23158, 30000, 'Novi potez', 3
exec sp_stanje_partije 100
exec sp_rang_lista
exec sp_chat 3000
exec sp_broj_igraca