import pybullet as p
import pybullet_data
import time
import numpy as np

# --------------------------------------------
# 1️⃣ Povezivanje sa PyBullet GUI okruženjem
# --------------------------------------------
p.connect(p.GUI)
p.setAdditionalSearchPath(pybullet_data.getDataPath())
p.resetSimulation()
p.setGravity(0, 0, -9.81)

# --------------------------------------------
# 2️⃣ Učitavanje ravne površine i drona
# --------------------------------------------
plane_id = p.loadURDF("plane.urdf")

# Koristimo jednostavan quadrotor model iz pybullet_data
drone_start_pos = [0, 0, 1]  # start visina 1m
drone_start_orientation = p.getQuaternionFromEuler([0, 0, 0])
drone_id = p.loadURDF("samurai.urdf", drone_start_pos, drone_start_orientation, useFixedBase=False)

# Cilj koji dron prati
target_pos = np.array([2, 2, 2])

# Parametri kontrole (P regulator za jednostavnu simulaciju)
Kp = 0.05

# --------------------------------------------
# 3️⃣ Glavna petlja simulacije
# --------------------------------------------
running = True
while running:
    # Dobij trenutnu poziciju drona
    pos, orn = p.getBasePositionAndOrientation(drone_id)
    pos = np.array(pos)

    # Vektor do cilja
    error = target_pos - pos

    # P-simplified kontrola: primeni silu proporcionalno grešci
    force = Kp * error
    force = np.clip(force, -10, 10)  # ograniči silu

    # Primeni silu na centar drona
    p.applyExternalForce(drone_id, -1, forceObj=force, posObj=pos, flags=p.WORLD_FRAME)

    # Korak simulacije
    p.stepSimulation()
    time.sleep(1. / 240.)

    # Zaustavljanje simulacije pritiskom na ESC
    keys = p.getKeyboardEvents()
    if 27 in keys:  # ESC
        running = False

p.disconnect()
print("Simulacija drona završena.")
