#include "stm32f4xx.h"

static void delay(volatile uint32_t count)
{
    while (count--) {
        __NOP();
    }
}

int main(void)
{
    /* 1. Enable clock for GPIOA */
    RCC->AHB1ENR |= RCC_AHB1ENR_GPIOAEN;

    /* 2. PA5 as output */
    GPIOA->MODER &= ~(3U << (5 * 2));
    GPIOA->MODER |=  (1U << (5 * 2));

    /* 3. Push-pull, high speed (optional) */
    GPIOA->OTYPER &= ~(1U << 5);
    GPIOA->OSPEEDR |= (3U << (5 * 2));

    while (1)
    {
        GPIOA->ODR ^= (1U << 5);   // toggle LED
        delay(800000);
    }
}
