#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <sys/msg.h>
#include <unistd.h>
#include <time.h>
#include <signal.h>
#include <sys/wait.h>


union semun{
    int val;
}arg;

typedef struct{
    long tip;
    int cvorovi[12];
    int operacija;
    int rezultat;
    int niz[4];
    int rd_broj;
    int pid;
    int rez[3];
}Operacija;


enum{PRISTUP_KLASTERU,PRIJAVA_TRI_REDNA_CVORA,OBAVLJENI_ZADACI};

int main(){

    key_t msgkey=ftok("./init.c",'Q');
    int msgid=msgget(msgkey,IPC_CREAT|0666);

    key_t shmkey=ftok("./init.c",'M');
    int shmid=shmget(shmkey,sizeof(Operacija),IPC_CREAT|0666);

    key_t semkey=ftok("./init.c",'S');
    int semid=semget(semkey,3,IPC_CREAT|0666);

    struct sembuf P={0,-1,0},V={0,1,0};
    Operacija *o=(Operacija*) shmat(shmid,NULL,0);

    P.sem_num=PRISTUP_KLASTERU;
    P.sem_op=-1;
    semop(semid,&P,1);
    printf("Korisnik generiše niz nasumičnih celih brojeva");
    
    for(int i=0;i<12;i++){
        int broj=rand();
        o->cvorovi[i]=broj;
    }

    int op=rand(); //kako da ti bira ili 1 ili 2 ili 3 ili 4
    if(op==1){
        o->operacija=1;
        //suma
    }
    else if(op==2){
        o->operacija=2;
        //proizvod
    }
    else if(op==3){
        o->operacija=3;
        //maximum
    }
    else{
        o->operacija=4;
        //minimum
    }

    
    o->tip=1;
    msgsnd(msgid,&o,sizeof(o)-sizeof(long),0);
    printf("Korisnik obavestava glavni cvor da su podaci uneti i prosledjuje mu operaciju za izvrsavanje\n");
    V.sem_num=PRISTUP_KLASTERU;
    V.sem_op=-1;
    semop(semid,&V,1);

    printf("Korisnik ceka rezultata\n");
    msgrcv(msgid,&o,sizeof(o)-sizeof(long),o->pid,0);

    printf("Kosrisnik ispisuje rezultata i izlazi iz programa\n");
    printf("%d\n",o->rezultat);


    return 0;

}