/*
    tezina predstavlja vreme obrade na ruteru 1 + distanca izmedju rutera 1 i 2 * vreme prenosa + vreme obrade na ruteru 2

    da bi se dobila distanca izmedju 2 rutera potrebno je naci distancu izmedju para koordinata (x1,y1) i (x2,y2)
*/

/*
    procedura
    -unesi sve rutere
    -pri unosu veza racunaj vreme prenosa izmedju rutera
    -primeni dijkstra algoritam i vrati tezinu od A do B
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define NEDEFINISANO -1
#define OBIDJEN 1
#define NEOBIDJEN 0

struct ruter
{
    float x;
    float y;
    float vremeObrade;
};

float izracunajVremePrenosa(struct ruter *prviRuter, struct ruter *drugiRuter, float brzina);

float izracunajDistancu(struct ruter *prviRuter, struct ruter *drugiRuter);

float dijkstra(float **veze, float *distance, int *prethodnici, int *obidjeni, int pocetniRuter, int krajnjiRuter, int n, int brojVeza);

int main()
{
    int n; //broj rutera
    scanf("%d", &n);

    struct ruter **ruteri = (struct ruter**)malloc(n * sizeof(struct ruter*));

    float **veze = (float**)(malloc(n * sizeof(float*)));
    float *distance = (float*)(malloc(n * sizeof(float)));
    int *prethodnici = (int*)(malloc(n * sizeof(int)));
    int *obidjeni = (int*)(malloc(n * sizeof(int)));


    int i;
    for(i = 0; i < n; i++)
    {
        ruteri[i] = (struct ruter*)malloc(n * sizeof(struct ruter));
        scanf("%f%f%f", &(ruteri[i]->x), &(ruteri[i]->y), &(ruteri[i]->vremeObrade));

        veze[i] = (float*)(malloc(n * sizeof(float)));
    }

    //inicijalizacija matrice povezanosti, distanci, prethodnika
    int j;
    for(i = 0; i < n; i++)
    {
        distance[i] = NEDEFINISANO;
        prethodnici[i] = NEDEFINISANO;
        obidjeni[i] = NEOBIDJEN;

        for(j = 0; j < n; j++)
        {
            veze[i][j] = NEDEFINISANO;
        }       
    }
        

    int m; //broj veza
    scanf("%d", &m);
    
    for(i = 0; i < m; i++)
    {
        int prviRuter, drugiRuter;
        float brzina;

        scanf("%d%d%f", &prviRuter, &drugiRuter, &brzina);
        veze[prviRuter][drugiRuter] = izracunajVremePrenosa(ruteri[prviRuter], ruteri[drugiRuter], brzina);
    }


    int pocetniRuter, krajnjiRuter;

    scanf("%d%d", &pocetniRuter, &krajnjiRuter);

    distance[pocetniRuter] = 0;

    float vreme = dijkstra(veze, distance, prethodnici, obidjeni, pocetniRuter, krajnjiRuter, n, m);

    printf("%.2f\n", vreme);
    return 0;
}

//ruter 1.vreme obrade + ruter2.vreme obrade + distanca izmedju * brzina prenosa
float izracunajVremePrenosa(struct ruter *prviRuter, struct ruter *drugiRuter, float brzina)
{
    float distanca = izracunajDistancu(prviRuter, drugiRuter);

    return(prviRuter->vremeObrade + drugiRuter->vremeObrade + distanca * brzina);
}

//distanca 2 tacke - sqrt((x1-x2)^2 + (y1-y2)^2)
float izracunajDistancu(struct ruter *prviRuter, struct ruter *drugiRuter)
{
    float x1 = prviRuter->x, y1 = prviRuter->y, x2 = drugiRuter->x, y2 = drugiRuter->y;

    return(sqrt((x1-x2)*(x1-x2) + (y1-y2)*(y1-y2)));
}

float dijkstra(float **veze, float *distance, int *prethodnici, int *obidjeni, int pocetniRuter, int krajnjiRuter, int n, int brojVeza)
{
    int i;
    for(i = 0; i < n; i++)
    {
        int u;
    }

    return 20;
}

/*
    dijkstra
    -inicijalizuj mat. povezanosti, niz distanci (d), niz prethodnika (PI), niz obidjenih(S)
    -skini element sa min tezinom sa niza Q (neobidjeni elementi)
    -relaksiraj veze za skinuti element
*/