#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct el {
    double b;
    int c;
    struct el *sledeci;
}El;

typedef struct {
    double x, y;
}Ruter;

int manje(double a, double b)
{
    if(a==-1) return 0;
    if(b==-1) return 1;
    return a<b;
}

double zbir(double a, double b)
{
    if(a==-1) return -1.0;
    if(b==-1) return -1.0;
    return a+b;
}

int dajMin(int *obidjen, double *d, int n)
{
    double min=-1.0;
    int minCvor=-1;
    int i;
    for(i=0; i<n; i++)
    {
        if(obidjen==0 && manje(d[i], min))
        {
            min=d[i];
            minCvor=i;
        }
    }
    return minCvor;
}

double rastojanje(Ruter *ruteri, int i, int j)
{
    double dx=ruteri[i].x-ruteri[j].x;
    double dy=ruteri[i].y-ruteri[j].y;

    return (dx*dx+dy*dy);
}

double rastojanjed(Ruter *ruteri, int i, int j)
{
    double dx=ruteri[i].x-ruteri[j].x;
    double dy=ruteri[i].y-ruteri[j].y;
    if(dx<0) dx=-1*dx;
    if(dy<0) dy=-1*dy;

    return dx+dy;
}

double dajVreme(Ruter *ruteri, int i, int j, double brzina)
{
    return brzina/rastojanjed(ruteri, i, j);
}

void relax(double **graf, double *d, int *pre, int u, int v, Ruter *ruteri)
{
    if(manje(zbir(dajVreme(ruteri, u, v, graf[u][v]), d[u]), d[v]))
    {
        d[v]=dajVreme(ruteri, u, v, graf[u][v])+d[u];
        pre[v]=u;
    }
}

void stampajMatricu(double **graf, int n)
{
    int i, j;
    for(i=0; i<n; i++)
    {
        for(j=0; j<n; j++)
        {
            printf("%.2lf ", graf[i][j]);
        }
        printf("\n");
    }
}

int main()
{
    int n, i, j;
    scanf("%d", &n);

    double **graf=(double **)malloc(n*sizeof(double *));
    double *vreme=(double *)malloc(n*sizeof(double));
    Ruter *ruteri=(Ruter *)malloc(n*sizeof(Ruter));
    double *d=(double *)malloc(n*sizeof(double));
    int *pre=(int *)malloc(n*sizeof(int));
    int *obidjen=(int *)malloc(n*sizeof(int));
    double x, y, t;
    for(i=0; i<n; i++)
    {
        scanf("%lf%lf%lf", &x, &y, &t);
        ruteri[i].x=x;
        ruteri[i].y=y;
        vreme[i]=t;

        graf[i]=(double *)malloc(n*sizeof(double));
        d[i]=-1.0;
        pre[i]=-1;
        obidjen[i]=0;
        for(j=0; j<n; j++)
        {
            graf[i][j]=-1.0;
        }
    }

    int m, p, q;
    double v;
    scanf("%d", &m);
    for(i=0; i<m; i++)
    {
        scanf("%d%d%lf", &p, &q, &v);
        graf[p][q]=v;
    }

    int A, B;
    scanf("%d%d", &A, &B);

    d[A]=0.0;
    int u;
    for(i=0; i<n; i++)
    {
        u=dajMin(obidjen, d, n);
        obidjen[u]=1;
        for(j=0; j<n; j++)
        {
            if(graf[u][j]!=-1.0 && pre[u]!=j)
            {
                relax(graf, d, pre, u, j, ruteri);
            }
        }
    }

    if(d[B]!=-1.0)
    {
        printf("%.2lf\n", d[B]+vreme[A]+vreme[B]);
    }

    stampajMatricu(graf, n);


    return 0;
}