#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <limits.h>
#include <math.h>

typedef struct Router {
    int x;
    int y;
    float t;
}Router;

int minDistance(float *dist, bool *visited, int n) {
    float min = INT_MAX;
    int x;

    for (int i = 0; i < n; i++) {
        if (dist[i] < min && visited[i] == false) {
            min = dist[i];
            x = i;
        }
    }

    return x;
}

void dijkstra(float **graf, int n, int a){
    float *dist = (float*)malloc(n * sizeof(float));
    bool *visited = (bool*)malloc(n * sizeof(bool));

    for (int i = 0; i < n; i++) {
        dist[i] = INT_MAX;
        visited[i] = false;
    }

    dist[a] = 0;

    for (int count = 0; count < n-1; count++) {
        int x = minDistance(dist, visited, n);
        visited[x] = true;

        for (int i = 0; i < n; i++){
            if (!visited[i] && graf[x][i] && dist[x] != INT_MAX && dist[i] > dist[x] + graf[x][i]) dist[i] = dist[x] + graf[x][i];
        }
    }
}

void main() {
    int n, m, a, b;
    scanf("%d", &n);

    float **graf = (float**)malloc(n * sizeof(float*));
    Router **routers = (Router**)malloc(n * sizeof(Router*));

    for (int i = 0; i < n; i++) {
        graf[i] = (float*)malloc(n * sizeof(float));
        for (int j = 0; j < n; j++) {
            graf[i][j] = 0;
        }
    }

    for (int i = 0; i < n; i++) {
        int x,y;
        float t;

        scanf("%d%d%f", &x, &y, &t);

        routers[i] = (Router*)malloc(sizeof(Router));
        routers[i] -> x = x;
        routers[i] -> y = y;
        routers[i] -> t = t;
    }

    scanf("%d", &m);

    for (int i = 0; i < m; i++) {
        int p,q;
        float v;

        scanf("%d%d%f", &p, &q, &v);
        graf[p][q] = sqrt((routers[p] -> x - routers[q] -> x)*(routers[p] -> x - routers[q] -> x) + (routers[p] -> y - routers[q] -> y)*(routers[p] -> y - routers[q] -> y)) / v;
    }

    scanf("%d%d", &a, &b);

    dijkstra(graf, n, a);

    printf("%.2f", graf[a][b] + routers[a] -> t + routers[b] -> t);
}
