#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <math.h>

typedef struct Koordinata{
    double x,y;
}Koordinata;

typedef struct Ruter{
    int id;
    Koordinata koordinata;
    double vreme_obrade;
}Ruter;

typedef struct Element{
    Ruter ruter;
    struct Element *sledeci;
}Element;

double **ucitajMatricu(int n){
    double** mat = (double**)malloc(n*sizeof(double*));

    for(int i=0; i<n; i++){
        mat[i] = (double*)calloc(n, n*sizeof(double));
    }

    return mat;
}

void stampajMatricu(int n, double **mat){
    for(int i=0; i<n; i++){
        for(int j=0; j<n; j++){
            printf("%lf ", mat[i][j]);
        }
        putchar('\n');
    }
}

void ucitajSet(Element **poc, Ruter r){
    Element *novi = (Element*)malloc(sizeof(Element));
    novi->ruter=r;
    novi->sledeci=NULL;

    Element *temp = *poc;
    Element *prethodni = NULL;

    while(temp && temp->ruter.vreme_obrade<r.vreme_obrade){
        prethodni=temp;
        temp=temp->sledeci;
    }

    novi->sledeci=temp;

    if(prethodni==NULL){
        *poc=novi;
        return;
    }

    prethodni->sledeci=novi;
}

void stampajSet(Element *poc){
    if(poc==NULL) return;

    while(poc){
        printf("%d %lf %lf %lf\n", poc->ruter.id ,poc->ruter.koordinata.x, poc->ruter.koordinata.y,poc->ruter.vreme_obrade);
        poc=poc->sledeci;
    }
}

Ruter pop(Element **poc){
    Element *temp = *poc;
    Ruter ruter = temp->ruter;
    *poc = (*poc)->sledeci;
    free(temp);

    return ruter;
}

Ruter nadjiRuter(Ruter *ruteri, int n, int id){
    for(int i=0; i<n; i++){
        if(ruteri[i].id==id) return ruteri[i];
    }   
}   

double Dijkstra(double **mat, int start, int end, int n, Ruter *ruteri){
   double *tezine = (double*)malloc(n*sizeof(double));
   for(int i=0; i<n; i++){
    tezine[i]=INT_MAX/2;
   }

   Element *poc = NULL;
   Ruter ruter = nadjiRuter(ruteri, n, start);
   ucitajSet(&poc, ruter);
   tezine[start]=ruter.vreme_obrade;

   while(poc){
        Ruter trenutni = pop(&poc);

        if(trenutni.id==end){
            return trenutni.vreme_obrade;
        }

        for(int i=0; i<n; i++){
            if(mat[trenutni.id][i]){
                Ruter povezani = nadjiRuter(ruteri, n, i);

                double xr = (trenutni.koordinata.x-povezani.koordinata.x);
                double yr = (trenutni.koordinata.y-povezani.koordinata.y);

                double rastojanje_izmedju_rutera = sqrt((xr*xr)+(yr*yr));
                double vreme_obrade_izmedju_rutera =  rastojanje_izmedju_rutera/mat[trenutni.id][i];

                double nova_tezina = trenutni.vreme_obrade+vreme_obrade_izmedju_rutera+povezani.vreme_obrade;
                if(tezine[i]>nova_tezina){
                    tezine[i]=nova_tezina;
                    Ruter novi = {povezani.id, povezani.koordinata, nova_tezina};
                    ucitajSet(&poc, novi);
                }
            }
        }
   }
    
   return 0; 
}

int main(){
    FILE *f = freopen("input.txt","r", stdin);
    int n;
    scanf("%d", &n);

    Ruter *ruteri = (Ruter*)malloc(n*sizeof(Ruter));
    for(int i=0; i<n; i++){
        double x,y,t;
        scanf("%lf%lf%lf", &x, &y, &t);

        Koordinata k = {x,y};

        Ruter ruter = {i, k, t};
        ruteri[i]=ruter;
    }
    // stampajSet(ruteri);
   

    int m;
    scanf("%d", &m);

    double **mat = ucitajMatricu(n);
     for(int j=0; j<m; j++){
        int p,q;
        double v;
        scanf("%d%d%lf", &p, &q, &v);
        mat[p][q]=v;
        mat[q][p]=v;
    }

    // stampajMatricu(n, mat);

    int start,end;
    scanf("%d%d", &start, &end);

    printf("%lf\n",Dijkstra(mat, start, end, n, ruteri));

    fclose(f);
    return 0;
}