#include<stdio.h>
#include<float.h>
#include<math.h>

#define INF DBL_MAX

double graf[100][100];
int posecen[100];
double dist[100];

void dijkstra(int start, int end, int n){
    for(int i=0; i<n; i++){
        posecen[i]=0;
        dist[i]=INF;
    }

    dist[start]=0.0;

    for(int i=0; i<n; i++){
        double minVreme=INF;
        int u = -1;

        for(int j=0; j<n; j++){
            if(!posecen[j] && dist[j]<minVreme){
                minVreme=dist[j];
                u = j;
            }
        }

        if(u==-1){
            break;
        }

        posecen[u]=1;

        if(u==end){
            return;
        }

        for(int j=0; j<n; j++){
            if(graf[i][j]!=INF){
                if(!posecen[j] && dist[u]+graf[u][j]<dist[j]){
                    dist[j]=dist[u]+graf[u][j];
                }
            }
        }
    }
}

int main(){
    int n, m;
    scanf("%d", &n);

    int nizX[n], nizY[n], vreme[n];
    for(int i=0; i<n; i++){
        scanf("%d %d %d", &nizX[i], &nizY[i], &vreme[i]);
    }

    for(int i=0; i<n; i++){
        for(int j=0; j<n; j++){
            graf[i][j]=INF;
        }
    }

    scanf("%d", &m);

    for(int i=0; i<m; i++){
        int p, q, v;
        scanf("%d %d %d", &p, &q, &v);

        double s = sqrt((nizX[p]-nizX[q])*(nizX[p]-nizX[q])+(nizY[p]-nizY[q])*(nizY[p]-nizY[q]));
        double t = s/v;
        double ukupnoVreme=t + (double)vreme[p] + (double)vreme[q];
        graf[p][q]=ukupnoVreme;
    }

    int A, B;
    scanf("%d %d", &A, &B);

    dijkstra(A, B, n);
    if(dist[B]==INF){
        printf("NE POSTOJI\n");
    }else{
        printf("%.2lf\n", dist[B]);
    }

    return 0;
}