#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef enum {WHITE, GRAY, BLACK}COLOR;

#define allocate(type, n) ((type*)malloc(n * sizeof(type)))
#define UNDEFINED -1

int left_less(float a, float b){
    if (a == UNDEFINED) return 0;
    if (b == UNDEFINED) return 1;
    return a < b;
}

int minimal(float *d, COLOR *color, int n){
    int min_value = UNDEFINED;
    int min_location = UNDEFINED;
    for (int v=0; v<n; v++){
        if (color[v] == GRAY && left_less(d[v], min_value)){
            min_value = d[v];
            min_location = v;
        }
    }
    return min_location;
}

void relax(float **graph, float *d, int *prev, int u, int v){
    if (d[u] == UNDEFINED) return;
    if (left_less(d[u] + graph[u][v], d[v])){
        prev[v] = u;
        d[v] = d[u] + graph[u][v];
    }
}

void dijkstra(float **graph, float *d, int *prev, COLOR *color, int n){
    while(1){
        int u = minimal(d, color, n);
        if (u == UNDEFINED) return;

        color[u] = BLACK;

        for (int v=0; v<n; v++){
            if (graph[u][v] != UNDEFINED && color[v] != BLACK){
                relax(graph, d, prev, u, v);
                if (color[v] == WHITE && d[v] != UNDEFINED) color[v] = GRAY;
            }
        }   
    }
}

int main(){
    int n;
    scanf("%d", &n);
    
    float *x = allocate(float, n);
    float *y = allocate(float, n);
    float *t = allocate(float, n);

    for (int i=0; i<n; i++){
        scanf("%f %f %f", &x[i], &y[i], &t[i]);
    }

    float *d = allocate(float, n);
    int *prev = allocate(int, n);
    COLOR *color = allocate(COLOR, n);

    float **graph = allocate(float*, n);

    for (int i=0; i<n; i++){
        d[i] = UNDEFINED;
        prev[i] = UNDEFINED;
        color[i] = WHITE;

        graph[i] = allocate(float, n);

        for (int j=0; j<n; j++){
            graph[i][j] = UNDEFINED;
        }
    }

    int m;
    scanf("%d", &m);

    for (int i=0; i<m; i++){
        int p, q;
        float v;
        scanf("%d %d %f", &p, &q, &v);

        float distance = sqrt(((x[p] - x[q]) * (x[p] - x[q])) + ((y[p] - y[q]) * (y[p] - y[q])));
        float time = distance/v;

        graph[p][q] = time;
    }

    int a, b;
    scanf("%d %d", &a, &b);

    d[a] = 0;
    color[a] = GRAY;

    dijkstra(graph, d, prev, color, n);

    if (d[b] == UNDEFINED){
        printf("NEMA VEZE.\n");
        return 0;
    }

    float time = d[b] + t[a] + t[b];

    printf("%.2f\n", time);

    return(0);
}