#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define INF 1e18
#define TRUE 1
#define FALSE 0


int nadjiMinimum(int *obidjen, double *d, int n)
{
    double min = INF;
    int minCvor = -1;
    for(int i = 0; i < n; i++)
    {
        if(obidjen[i] == FALSE && d[i] < min)
        {
            min = d[i];
            minCvor = i;
        }
    }
    return minCvor;
}

int main()
{
    int n;
    scanf("%d", &n);
    double *x = (double*)malloc(n * sizeof(double));
    double *y = (double*)malloc(n * sizeof(double));
    double *t = (double*)malloc(n * sizeof(double));

    for(int i = 0; i < n; i++)
    {
        scanf("%lf %lf %lf", &x[i], &y[i], &t[i]);
    }
    int m;
    scanf("%d", &m);
    double **graf = (double**)malloc(n * sizeof(double));
    for(int i = 0; i < n; i++)
    {
        graf[i] = (double*)malloc(n * sizeof(double));
        for(int j = 0; j < n; j++)
        {
            graf[i][j] = INF;
        }
    }

    for(int i = 0; i < m; i++)
    {
        int u, v;
        double brzina;
        scanf("%d %d %lf", &u, &v, &brzina);
        double dx = x[u] - x[v];
        double dy = y[u] - y[v];
        double dist = sqrt(dx * dx + dy * dy);

        double vremePrenosa = dist / brzina;
        graf[u][v] = vremePrenosa;
        graf[v][u] = vremePrenosa;
    }

    int A, B;
    scanf("%d %d", &A, &B);
    double *d = (double*)malloc(n * sizeof(double));
    int *obidjen = (int*)malloc(n * sizeof(int));
    
    for(int i = 0; i < n; i++)
    {
        d[i] = INF;
        obidjen[i] = FALSE;
    }

    d[A] = t[A];
    for(int i = 0; i < n; i++)
    {
        int u = nadjiMinimum(obidjen, d, n);
        if(u == -1) break;
        obidjen[u] = TRUE;
        for(int v = 0; v < n; v++)
        {
            if(obidjen[v] == FALSE && graf[u][v] < INF)
            {
                if(d[u] + graf[u][v] + t[v] < d[v])
                {
                    d[v] = d[u] + graf[u][v] + t[v];
                }
            }
        }
    }
    printf("%.2lf\n", d[B]);

    return 0;
}