#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define TRUE 1
#define FALSE 0
#define INF -1.0
#define NILL -1

typedef struct ruter
{
    //int x; // x koordinata
    //int y; // y koordinata
    double duzina; // duzina veze od dekartovog k.s.
    int vreme; // vreme obrade paketa
} Ruter;

int jeManji ( double x, double y )
{
    if( x == INF ) return FALSE;
    if( y == INF ) return TRUE;

    return x < y;
}

int nadjiNajboljeg ( int *obidjen, double *d, int n )
{
    int min = INF;
    int minCvor = NILL;

    for( int i = 0; i < n; i++)
        if( obidjen[ i ] == FALSE && jeManji( d[ i ], min ) )
        {
            min = d[ i ];
            minCvor = i;
        }

    return minCvor;
}

void relax ( double **graf, double *d, int *pret, int u, int v )
{
    if( d[ u ] != INF && jeManji( graf[ u ][ v ] + d[ u ], d[ v ] ) )
    {
        d[ v ] = graf[ u ][ v ] + d[ u ];
        pret[ v ] = u;
    }
}

void dijkstra ( double **graf, double *d, int *pret, int *obidjen, int n )
{
    int u;
    while( ( u = nadjiNajboljeg( obidjen, d, n ) ) != NILL )
    {
        obidjen[ u ] = TRUE;

        for( int v = 0; v < n; v++ )
            if( graf[ u ][ v ] != INF && obidjen[ v ] == FALSE)
                relax( graf, d, pret, u, v );
    }
}

int main ()
{
    // broj veza
    int n;
    scanf( "%d", &n );

    // inicijalizacija
    double **graf = ( double** ) malloc ( n * sizeof ( double* ) );
    for( int i = 0; i < n; i++ )
        graf[ i ] = ( double* ) malloc ( n * sizeof ( double ) );
    
    double *d = ( double* ) malloc ( n * sizeof ( double ) );
    int *pret = ( int* ) malloc ( n * sizeof ( int ) );
    int *obidjen = ( int* ) malloc ( n * sizeof ( int ) );

    // inicijalizacija
    for( int i = 0; i < n; i++ )
    {
        for( int j = 0; j < n; j++ )
            graf[ i ][ j ] = INF;

        d[ i ] = INF;
        pret[ i ] = NILL;
        obidjen[ i ] = FALSE;
    }

    Ruter ruteri[ n ];
    // unos duzine i vremena obrade
    for( int i = 0; i < n; i++ )
    {
        int x, y, I;
        scanf( "%d%d%d", &x, &y, &I );

        int zaKoren = x*x + y*y;
        double koren = sqrt( zaKoren );

        ruteri[ i ].duzina = koren;
        ruteri[ i ].vreme = I;
    }

    // broj veza
    int m;
    scanf( "%d", &m );

    for( int i = 0; i < m; i++ )
    {
        int u, v, t;
        scanf( "%d%d%d", &u, &v, &t );

        double tezina = (ruteri[ u ].duzina + ruteri[ v ].duzina) / t + ruteri[ v ].vreme + ruteri[ u ].vreme; // tezina veze

        graf[ u ][ v ] = graf[ v ][ u ] = tezina;
    }

    // id pocetnog i krajnjeg rutera
    int a, b;
    scanf( "%d%d", &a, &b );

    d[ a ] = 0;

    dijkstra( graf, d, pret, obidjen, n );

    double vremePaketa = -1.0;

    if( d[ b ] != INF )
        vremePaketa = d[ b ];

    printf( "%.2f\n", vremePaketa);

    
    return 0;
}