#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define allocate(type, n) ((type*) malloc ((n) * sizeof(type)))

#define INF -1
#define TRUE 1
#define FALSE 0

typedef struct element
{
    double distance;
    double speed;
} Element;

typedef struct point
{
    double x;
    double y;
    double t;
} Point;

double distance(int x1, int y1, int x2, int y2)
{
    return sqrt((x1-x2)*(x1-x2) + (y1-y2)*(y1-y2));
}

int isLess(double i, double j)
{
    if(i == INF) return FALSE;
    if(j == INF) return TRUE;

    return i < j;
}

int extractMin(int *visited, double *d, int n)
{
    double minD = INF;
    int minNode = INF;

    for(int i = 0; i < n; i++)
    {
        if(!visited[i] && isLess(d[i], minD))
        {
            minD = d[i];
            minNode = i;
        }
    }
    return minNode;
}

void relax(Element **graph, double *d, Point *points, int u, int v)
{
    double time;

    double distance = graph[u][v].distance;
    double speed = graph[u][v].speed;
    double timeToDoU = points[u].t;
    double timeToDoV = points[v].t;

    time = (distance / speed) + timeToDoU;

    if(isLess(time + d[u], d[v]))
    {
        d[v] = time + d[u];
    }
}

void dijkstra(Element **graph, double *d, Point *points, int n)
{
    int *visited = allocate(int, n);
    for(int i = 0; i < n; i++)
        visited[i] = FALSE;

    int u;
    while((u = extractMin(visited, d, n)) != INF)
    {
        visited[u] = TRUE;

        for(int v = 0; v < n; v++)
            if(graph[u][v].distance != INF && graph[u][v].speed != INF && !visited[v])
                relax(graph, d, points, u, v);
    }
    free(visited);
}

int main()
{
    int n;
    scanf("%d", &n);

    Element **graph = allocate(Element*, n);
    double *d = allocate(double, n);
    for(int i = 0; i < n; i++)
    {
        d[i] = INF;
        graph[i] = allocate(Element, n);
        for(int j = 0; j < n; j++)
        {
            graph[i][j].distance = INF;
            graph[i][j].speed = INF;
        }
    }

    for(int i = 0; i < n; i++)
        graph[i][i].distance = 0.0;
        
    Point *points = allocate(Point, n);
    int cnt = 0;
    for(int i = 0; i < n; i++)
    {
        Point p;
        scanf("%lf %lf %lf", &p.x, &p.y, &p.t);

        points[cnt++] = p;
    }

    for(int i = 0; i < n; i++)
    {
        for(int j = i+1; j < n; j++)
        {
            double di = distance(points[i].x, points[i].y, points[j].x, points[j].y);
            graph[i][j].distance = graph[j][i].distance = di;
        }
    }

    int m;
    scanf("%d", &m);

    for(int i = 0; i < m; i++)
    {
        int p, q;
        double v;
        scanf("%d %d %lf", &p, &q, &v);

        graph[p][q].speed = graph[q][p].speed = v;
    }

    int A, B;
    scanf("%d %d", &A, &B);

    d[A] = 0;
    dijkstra(graph, d, points, n);

    if(d[B] != INF)
        printf("%.2lf\n", d[B] + points[B].t);
    else
        printf("NE POSTOJI PUT\n");

    for(int i = 0; i < n; i++) free(graph[i]);
    free(graph);
    free(d);
    free(points);

    return 0;
}