#include<stdio.h>
#include<stdlib.h>
#include<math.h>

#define INF -1
#define NILL -1
#define POVEZANO 1
#define NEPOVEZANO 0
#define TRUE 1
#define FALSE 0

typedef struct Element{
    int x;
    int y;
    int t;
    
}Element;

int jeManji(int x, int y){

    if( x == INF) return FALSE;
    if(y == INF) return TRUE;

    return x < y;
}

int nadjiMinimum(int* obidjen, int* d, int n){

    int min = INF, minCvor = NILL;

    for(int i = 0; i< n; i++){

        //int u = obidjen[0];

        for(int v = 1; v < n; v++){

            if(!obidjen[v] && jeManji(d[i], d[v])){
                min = d[i];
                minCvor = i;
            }

        }

    }

    return minCvor;
}


void relax(Element** graf, int* obidjen, int* d, int n){

    for(int i = 0; i < n; i++){
        for(int v = 0; v < n; v++){

            if(!obidjen[v] && graf[i][v] != NEPOVEZANO && nadjiMinimum( d[u] + graf[u][v], d[v])){
                d[v] = d[u] + graf[u][v];
            }
        }
    }
}

void dijkstra(int** graf, int *obidjen, int *d, int n){
 
    
  for(int i = 0; i < n; i++ ){
     for(int j = 0; j < n; j++){

        if(!obidjen[j] && graf[i][j] == POVEZANO){
            relax(&graf, &obidjen, &d, n);
        }
     }
  }


}

int main(){

    int n;
    scanf("%d", &n);

    Element* elementi = (Element*)malloc(n * sizeof(Element));
    Element** graf = (Element**)malloc(n * sizeof(Element*));
    int* obidjen = (int*)malloc(n * sizeof(int));
    int* d = (int*)malloc(n * sizeof(int));

    for(int i = 0; i < n; i++){
        graf[i] = (Element*)malloc(n * sizeof(Element));

        for(int j = 0; j < n; j++){
            graf[i][j] = graf[j][i] = NEPOVEZANO;

        }

        obidjen[i] = d[i] = NILL;
    }

    for(int i = 0; i < n; i++){

        int x, y, t;
        scanf("%d%d%d", &x, &y, &t);

        elementi[i].x = x;
        elementi[i].y = y;
        elementi[i].t = t;
    }

    int m;
    scanf("%d", &m);

     for(int i = 0; i < m; i++){

        int p, q, v;
        scanf("%d%d%d", &p, &q, &v);

        graf[p][q] = graf[q][p] = v * sqrt((elementi[p].x - elementi[q].x) * (elementi[p].x - elementi[q].x) + (elementi[p].y - elementi[q].y) * (elementi[p].y - elementi[q].y)) + elementi[p].t + elementi[q].t;
     }

     int A, B;
     scanf("%d%d", &A, &B);

     int resenje =  (double) graf[A][B];

     printf("%.2f\n", resenje);

     for(int i = 0; i < n; i++){
        free(graf[i]);
     }

     free(graf);
     free(obidjen);
     free(d);

     return 0;
}