#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <stdbool.h>
#include <math.h>

typedef struct ruter{
    int x;
    int y;
    int brzina;
}ruter;

int abss(int x,int y){
    int rez=(x-y>=0)? x-y : y-x;
    return rez;
}

double distKord(int x1,int y1,int x2,int y2){
    int x=abss(x1,x2);
    int y=abss(y1,y2);
    double s=sqrt(x*x+y*y);
    return s;
}

int minDist(int *weight,bool *visited,int n){
    int mini=INT_MAX,min_index;
    for(int i=0;i<n;i++){
        if(visited[i]==false && weight[i]<mini)
            min_index=i,mini=weight[i];
    }
    return min_index;
}

int *dijkstra(int **graph,int n,int src){
    int *weight=malloc(n*sizeof(int));
    bool *visited=malloc(n*sizeof(bool));

    for(int i=0;i<n;i++){
        weight[i]=INT_MAX,visited[i]=false;
    }
    weight[src]=0;

    for(int count=0;count<n;count++){
        int u=minDist(weight,visited,n);
        visited[u]=true;

        for(int v=0;v<n;v++){
            if(!visited[v] && graph[u][v]
               && weight[u]!=INT_MAX
               && weight[v]> graph[u][v]+weight[u])
                    weight[v]=graph[u][v]+weight[u];
        }
    }

    return weight;
}

void stampaj(int **graph,int n){
    for(int i=0;i<n;i++){
        for(int j=0;j<n;j++){
            printf("%d ",graph[i][j]);
        }
        printf("\n");
    }
}

int main(){
    //unos rutera
    int n;
    scanf("%d",&n);
    ruter *ruteri=malloc(n*sizeof(ruter));
    for(int i=0;i<n;i++){
        int x,y,t;
        scanf("%d%d%d",&x,&y,&t);
        ruteri[i].x=x;
        ruteri[i].y=y;
        ruteri[i].brzina=t;
    }

    //unos mreze
    int **graph=malloc(n*sizeof(int*));
    for(int i=0;i<n;i++){
        graph[i]=malloc(n*sizeof(int));
        for(int j=0;j<n;j++){
            graph[i][j]=0;
        }
    }
    int m;
    scanf("%d",&m);
    for(int i=0;i<m;i++){
        int p,q,v;
        scanf("%d%d%d",&p,&q,&v);
        graph[p][q]=v;
    }

    int poc,kraj;
    scanf("%d%d",&poc,&kraj);
    int *najkraci=malloc(n*sizeof(int));
    najkraci=dijkstra(graph,n,poc);
    int brzina=najkraci[kraj];

    ruter pom1=ruteri[poc];
    ruter pom2=ruteri[kraj];
    double distanca=distKord(pom1.x,pom1.y,pom2.x,pom2.y);

    double time=distanca/brzina;
    //na izracunato vreme dodati vreme obrade paketa
    time=time+pom1.brzina+pom2.brzina;
    printf("%.2f",time);


    //znam da ne moze da se doda samo ovako dve brzine jer najbrzi put
    //moze biti preko vise rutera umesto jedne veze izmedju mreza
    //nemam vremena da smislim kvalitetno resenje


    return 0;
}
