#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define BESKONACNO 10000000
#define NEDEFINISANO -1
#define TRUE 1
#define FALSE 0

int nadjiMinimalno(double *d,int *posecen,int n){

    int mind=BESKONACNO;
    int miniIndeks=NEDEFINISANO;
    for(int i=0;i<n;i++){

        if(posecen[i]==FALSE &&d[i]<mind){

            mind=d[i];
            miniIndeks=i;

        }

    }
    return miniIndeks;

}


void relax(double **graf,double *d,int trenutni,int sledeci){

    if(d[sledeci]>d[trenutni]+graf[trenutni][sledeci]){
    d[sledeci]=d[trenutni]+graf[trenutni][sledeci];
    }      


}

void dijkstra(double **graf,double *d,int *posecen,int n,int s,double *t){

    d[s]=0;
    for(int i=0;i<n;i++){
        int trenutni=nadjiMinimalno(d,posecen,n);
        if(trenutni==NEDEFINISANO){
            break;
        }
        posecen[trenutni]=TRUE;
        for(int sledeci=0;sledeci<n;sledeci++){
            if(graf[trenutni][sledeci]!=BESKONACNO && posecen[sledeci]==FALSE){
                relax(graf,d,trenutni,sledeci);
            }
        }
    }


}


int main(){

    int n;
    scanf("%d",&n);

    double **graf=(double**)malloc(n*sizeof(double*));
    for(int i=0;i<n;i++){
        graf[i]=(double*)malloc(n*sizeof(double));
    }

    double *d=(double*)malloc(n*sizeof(double));
    int *posecen=(int*)malloc(n*sizeof(int));

    for(int i=0;i<n;i++){
        for(int j=0;j<n;j++){
            graf[i][j]=BESKONACNO;
        }
        d[i]=BESKONACNO;
        posecen[i]=FALSE;
    }

    
    double *x=(double*)malloc(n*sizeof(double));
    double *y=(double*)malloc(n*sizeof(double));
    double *t=(double*)malloc(n*sizeof(double));

    for(int i=0;i<n;i++){
        scanf("%lf%lf%lf",&x[i],&y[i],&t[i]);
    }

    for(int i=0;i<n;i++){
        for(int j=0;j<n;j++){

            double dx=x[i]-x[j];
            double dy=y[i]-y[j];
            
            graf[i][j]=sqrt(dx*dx+dy*dy);


        }
    }//racunanje rastojanja izmedju tacaka i smestanje rastojanja u graf
    int m;
    scanf("%d",&m);
    for(int i=0;i<m;i++){

        int ji,ki;
        double mi;
        scanf("%d%d%lf",&ji,&ki,&mi);
        graf[ji][ki]=graf[ji][ki]/mi;
    }//i posle deljenje sa brzinom da bi se dobio put 
    for(int i=0;i<n;i++){
        for(int j=0;j<n;j++){
            graf[i][j]+=(t[i]+t[j]);
        }
    }//ovde dodajem vrme potrebno u odredjenoj tacki odnosno ruteru nakon racunanja brzine



int a,b;
scanf("%d%d",&a,&b);

dijkstra(graf,d,posecen,n,a,t);
printf("%.2lf",d[b]);
}
