#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define INF 1000000;

//ruter:
typedef struct cvor
{
    int sused; //indeks za povezivanje sa ruterima, pocetak povezane liste
    //int x;
    //int y;
    //int vreme; //vreme obrade paketa
    int duzinaMedijuma;
    int brzinaPrenosa;
    struct cvor* sledeci;

}cvor;
//tezina je vreme u grafu

typedef struct graf
{
    int n;
    //cvor **indeksiSvihCvorova; //cuvace se indeksi svih cvorova gde cemo moci pristupati x,y i t vrednostima
    int *x; //iksevi svih rutera
    int *y; //ipsiloni svih rutera
    int *t; //vremena svih rutera
    int *d; //duzine medijuma svih rutera
    cvor **niz; //ovde cemo imati niz povezanih listi odnosno susede

}graf;

void dodajVezu(graf *g,int indeksPocetnog,int indeksSusednog,int brzina)
{
    cvor *novi = (cvor *)malloc(sizeof(cvor));
    novi->sused = indeksSusednog;
    novi->brzinaPrenosa = brzina;
    novi->duzinaMedijuma=(int)(abs(pow(g->x[indeksPocetnog]-g->x[indeksSusednog],2)+pow(g->y[indeksPocetnog]-g->y[indeksSusednog],2)));
    novi->sledeci = g->niz[indeksPocetnog];
    g->niz[indeksPocetnog] = novi;
}

graf *napraviGraf()
{
    int n,m;
    printf("\nUnesi n (broj cvorova): ");
    scanf("%d",&n);
    graf *g = (graf *)malloc(sizeof(graf));
    g->niz = (cvor **)malloc(n*sizeof(cvor*));
    //g->indeksiSvihCvorova = (cvor **)malloc(n*sizeof(cvor));
    g->x = (int *)calloc(n,sizeof(int));
    g->y = (int *)calloc(n,sizeof(int));
    g->t = (int *)calloc(n,sizeof(int));

    g->n = n;

    for(int i=0;i<n;i++)
    {
        g->niz[i] = NULL;
        int x,y,t;
        //cvor *nov = (cvor *)malloc(sizeof(cvor));
        scanf("%d %d %d",&x,&y,&t);
        g->x[i] = x;
        g->y[i] = y;
        g->t[i] = t;
        /*nov->duzinaMedijuma = 0;
        nov->brzinaPrenosa = 0;
        g->indeksiSvihCvorova[i] = nov;*/
    }


    printf("\nUnesi m (broj veza): ");
    scanf("%d",&m);

    for(int j=0;j<m;j++)
    {
        int p,q,v;
        scanf("%d %d %d",&p,&q,&v);
        dodajVezu(g,p,q,v);
    }

    return g;

}

void ispisGrafa(graf *g)
{

    for(int i=0;i<g->n;i++)
    {
        printf("\nRuter{%d}(x:%d y:%d vremeObrade:%d): ",i,g->x[i],g->y[i],g->t[i]);
        cvor *t = g->niz[i];
        while(t)
        {
            int v = t->sused;
            printf("Ruter[%d](x:%d y:%d vremeObrade:%d duzina: %d) - ",v,g->x[v],g->y[v],g->t[v],t->duzinaMedijuma);
            t=t->sledeci;
        }
        printf("NULL\n");
    }
}


void dijkstra(graf *g,int start,int end)
{
    int *poseceni = (int *)calloc(g->n,sizeof(int));
    int *dist = (int *)malloc(sizeof(int)*g->n);

    for(int i=0;i<g->n;i++)
    {
        dist[i]=INF;
    }

    dist[start]=0;

    for(int i=0;i<g->n;i++)
    {
        int u=-1,min=INF;
        for(int v=0;v<g->n;v++)
        {
            if(!poseceni[v] && dist[v]<min)
            {
                min = dist[v];
                u = v;
            }
        }

        if(u==-1) break;

        poseceni[u] = 1;

        cvor *t = g->niz[u];

        while(t)
        {
            int v = t->sused;
            if(dist[u]+g->t[t->sused] < dist[v])
            {
                dist[v]=dist[u]+g->t[t->sused];
            }
            t=t->sledeci;
        }

    }

    for(int i=0;i<g->n;i++)
    {
        if(i==end)
        {
            printf("\nNajkrace vreme za koje paket moze stici od rutera %d do rutera %d je : %.2f\n",start,end,round(dist[i]));
            break;
        }

        
    }


}

int main()
{
    graf *g = napraviGraf();
    ispisGrafa(g);
    int pocetniRuter,krajnjiRuter;
    printf("\n\nUnesi indeks pocetnog i indeks krajnjeg rutera: ");
    scanf("%d %d",&pocetniRuter,&krajnjiRuter);
    printf("\n\n");
    dijkstra(g,pocetniRuter,krajnjiRuter);
}