#include <stdio.h>
#include <stdlib.h>

#define INF 100000;

typedef struct cvor{
    int sused;
    int vrednost;
    struct cvor* sledeci;
} cvor;

typedef struct graf{
    int n;
    cvor** niz;
} graf;

typedef struct cvorPod{
    float X;
    float Y;
    float T;
} cvorPod; //podaci za ruter koordinate i vreme obrade paketa

cvorPod* ruter(int x, int y, int t){
    cvorPod* novi = (cvorPod*)malloc(sizeof(cvorPod));
    novi->X = x;
    novi->Y = y;
    novi->T = t;
    
    return novi;
}
void stampaRutera(cvorPod* nizRutera, int n){
    for(int i=0 ; i<n ; i++){
        printf("ruter[%d] X: %.2f Y: %.2f T: %.2f\n",i+1, nizRutera[i].X, nizRutera[i].Y, nizRutera[i].T);
    }
}

graf* napraviGraf(int n){
    graf* g = (graf*)malloc(sizeof(graf));
    g->n = n;
    g->niz = (cvor**)malloc(g->n*sizeof(cvor*));

    for(int i=0 ; i<g->n ; i++){
        g->niz[i] = NULL;
    }

    return g;
}

void dodajCvor(graf* g, int id, int sused, int vrednost){
    cvor* novi = (cvor*)malloc(sizeof(cvor));
    novi->sused = sused;
    novi->vrednost = vrednost;
    novi->sledeci = g->niz[id];
    g->niz[id] = novi;
}

void stampa(graf* g){
    for(int i=0 ; i<g->n ; i++){
        printf("cvor[%d] ",i+1);
        cvor* temp = g->niz[i];
        while(temp){
            printf("[sused: %d vrednost: %d] -> ",temp->sused+1, temp->vrednost);
            temp = temp->sledeci;
        }
        printf("NULL\n");
    }
}

void oslobodiMemoriju(graf* g){
    for(int i=0 ; i<g->n ; i++){
        cvor* temp = g->niz[i];
        while(temp){
            cvor* stari = temp;
            temp = temp->sledeci;
            free(stari);
        }
    }

    free(g->niz);
    free(g);
}

void dijkstra(graf* g, cvorPod* nizRutera, int start, int kraj){ // algoritam za racunanje najkrace distance od cvora A do cvora B
    int* poseceni = (int*)calloc(g->n,sizeof(int));
    int* dist = (int*)malloc(g->n*sizeof(int));
    //int* brzinaRada = (int*)malloc(g->n*sizeof(int));

    for(int i=0 ; i<g->n ; i++){
        dist[i] = INF;
        //brzinaRada[i] = -1;
    }

    /*
        cvorPod cuva podatke o cvoru, treba da se racuna distanca od cvora do cvora i to da se 
        pakuje u dist[] i da se cuva i distanca i brzina rada, trenutno sam neke delova obrisao
        i zakomentarisao od enemtualnih gresaka i problema prio pokretanju i stavio sam cisto 
        neku vrednost da se pokaze da algoritam radi
    */

    dist[start] = 0;

    for(int i=0 ; i<g->n ; i++){
        int min = INF;
        int u = -1;
        for(int j=0 ; j<g->n ; j++){
            if(poseceni[j]==0 && dist[j]<min){ //da li je posecen i da li je distanca ta koja nam treba
                min = dist[j];
                u = j;
                //brzina ucitavanja
            }
        }

        if(u==-1) break;

        poseceni[u] = 1;

        cvor* temp = g->niz[u];
        while(temp){
            int v = temp->sused;
            if(temp->vrednost + dist[u]<dist[v]){
                //dodajemo vrednost u distancu, trebace za dva faktora, distanca i brzina ucitavanja
                dist[v] = temp->vrednost + dist[u];
            }
            temp = temp->sledeci;
        }
    }
    
    for(int i=0 ; i<g->n ; i++){
        if(i==kraj){
            printf("Najmanja distanca od cvora: [%d] do cvora [%d] je: %d\n",start+1, i+1, dist[i]);
        }
    }

    free(poseceni);
    free(dist);
}

int main(){
    int n, m;
    printf("Unesite broj cvorova: ");
    scanf("%d", &n);

    graf* g = napraviGraf(n);

    cvorPod* nizRutera = (cvorPod*)malloc(n*sizeof(cvorPod));
    for(int i=0 ; i<n ; i++){
        printf("Unesite X i Y koordinate za ruter [%d] i brzinu obrade paketa: ", i+1);
        float x,y,t;
        scanf("%f %f %f", &x, &y, &t);
        cvorPod* novi = ruter(x,y,t);
        
        nizRutera[i] = *novi;
    }
    
    stampaRutera(nizRutera, n);


    printf("Unesite broj veza: ");
    scanf("%d", &m);

    for(int i=0 ; i<m ; i++){
        int sused, id, vrednost;
        printf("Unesite sused, na koga se nadovezuje zatim vrednost: ");
        scanf("%d %d %d", &id, &sused, &vrednost);
        dodajCvor(g,id-1,sused-1,vrednost);
    }

    int A, B;
    printf("Unesite startan ruter i ruter do koga idemo: ");
    scanf("%d %d", &A, &B);

    dijkstra(g, nizRutera, A-1, B-1);
    stampa(g);
    oslobodiMemoriju(g);
}