#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define TRUE 1
#define FALSE 0
#define NEDEFINISANO -1
#define INF 0x7fffffff

int jeManji(double i, double j)
{
    return i < j;
}

int NadjiMinimum(int *obidjen, double *d, int n)
{
    int minCvor = NEDEFINISANO;
    double min = INF;
    for(int i = 0; i < n; i++)
    {
        if(!obidjen[i] && jeManji(d[i], min))
        {
            min = d[i];
            minCvor = i;
        }
    }
    return minCvor;
}

void Relax(double **w, double *t, double *d, int *pret, int u, int v)
{
    double pom = d[u] + w[u][v] + t[v];
    if(jeManji(pom, d[v]))
    {
        d[v] = pom;
        pret[v] = u;
    }
}

void Dijkstra(double **w, double *t, int *obidjen, double *d, int *pret, int n)
{
    for(int i = 0; i < n; i++)
    {
        int u = NadjiMinimum(obidjen, d, n);
        if(u == NEDEFINISANO) break;

        obidjen[u] = TRUE;
        for(int v = 0; v < n; v++)
        {
            if(w[u][v] < INF && obidjen[v] == FALSE)
            {
                Relax(w, t, d, pret, u, v);
            }
        }
    }
}

int main()
{
    int n;
    scanf("%d", &n);

    double *x = (double *)malloc(n * sizeof(double));
    double *y = (double *)malloc(n * sizeof(double));
    double *t = (double *)malloc(n * sizeof(double));

    for(int i = 0; i < n; i++)
    {
        scanf("%lf%lf%lf", &x[i], &y[i], &t[i]);
    }

    int m;
    scanf("%d", &m);

    double **w = (double **)malloc(n * sizeof(double *));
    for(int i = 0; i < n; i++)
    {
        w[i] = (double *)malloc(n * sizeof(double));
        for(int j = 0; j < n; j++)
        {
            w[i][j] = INF;
            w[i][i] = 0.0;
        }
    }

    for(int i = 0; i < m; i++)
    {
        int p, q;
        double brzina;
        scanf("%d%d%lf", &p, &q, &brzina);

        double dx = x[p] - x[q];
        double dy = y[p] - y[q];
        double rastojanje = sqrt(dx * dx + dy * dy);

        double vreme = rastojanje / brzina;

        w[p][q] = w[q][p] = vreme;
    }

    int A, B;

    scanf("%d%d", &A, &B);

    double *d = (double *)malloc(n * sizeof(double));
    int *pret = (int *)malloc(n * sizeof(int));
    int *obidjen = (int *)malloc(n * sizeof(int));

    for(int i = 0; i < n; i++)
    {
        d[i] = INF;
        pret[i] = NEDEFINISANO;
        obidjen[i] = FALSE;
    }

    d[A] = t[A];
    
    Dijkstra(w, t, obidjen, d, pret, n);

    printf("%.2f\n", d[B]);

    return 0;
}