#include <stdio.h>
#include <stdlib.h>
#include <math.h>

//v = s/t
#define INF 10000000
#define NEDEFINISANO -1
#define TRUE 1
#define FALSE 0

int nadjiNajmanji(int *poseceni, double *d, int n){
    int minCvor;
    double minTezina = INF;
    for(int i = 0; i < n; i++){
        if(poseceni[i] == FALSE && d[i] < minTezina){
            minTezina = d[i];
            minCvor = i;
        }
    }
    return minCvor;
}

void relax(double **graf, double *d, int *prethodnici, int trenutni, int sledeci){
    if(d[sledeci] > d[trenutni] + graf[trenutni][sledeci]){
        d[sledeci] = d[trenutni] + graf[trenutni][sledeci];
        
        //doradi
    }
}

void dijkstra(double **graf, double *d, int *prethodnici, int n, int s, int *poseceni){
    d[s] = 0;
    for(int i = 0; i < n; i++){
        int trenutni = nadjiNajmanji(poseceni, d, n);
        if(trenutni == NEDEFINISANO) break;
        poseceni[trenutni] = TRUE;
        for(int sledeci = 0; i < n; i++){
            if(poseceni[sledeci] == FALSE && graf[trenutni][sledeci] != NEDEFINISANO){
                relax(graf, d, prethodnici, trenutni, sledeci);
                prethodnici[sledeci] = trenutni;
            }
        }
    }
}

double euklidskoRastojanje(double x1, double x2, double y1, double y2){
    double dx = x1 -x2;
    double dy = y1 - y2;

    return sqrt(dx*dx + dy*dy);
}

int main(){

    int n;
    scanf("%d", &n);

    double **graf = (double**)malloc(n * sizeof(double*));
    for(int i = 0; i < n; i++){
        graf[i] = (double*)malloc(n * sizeof(double));
    }

    double *d = (double*)malloc(n*sizeof(double));
    int *prethodnici = (int*)malloc(n*sizeof(int));
    int *poseceni = (int*)malloc(n * sizeof(int));

    // for(int i = 0; i < n; i++){
    //     d[i] = (double*)malloc(n * sizeof(double));
    //     prethodnici[i] = (double*)malloc(n * sizeof(double));
    //     poseceni[i] = (double*)malloc(n * sizeof(double));
    // }

    for(int i = 0; i < n; i++){
        for(int j = 0; j < n; j++){
            graf[i][j] = INF;
        }
        d[i] = INF;
        prethodnici[i] = NEDEFINISANO;
        poseceni[i] = FALSE;
    }

    double *x= (double*)malloc(n * sizeof(double));
    double *y= (double*)malloc(n * sizeof(double));
    double *t= (double*)malloc(n * sizeof(double));


    for(int i = 0; i < n; i++){
        scanf("%lf", &x[i]);
        scanf("%lf", &y[i]);
        scanf("%lf", &t[i]);
    }

    double **resenje = (double**)malloc(n * n * sizeof(double*));
    for(int i = 0; i < n; i++){
        resenje[i] = (double*)malloc(n * sizeof(double));
    }   

    for(int i = 0; i < n; i++){
        for(int j = 0; j < n; j++){
            resenje[i][j] = euklidskoRastojanje(x[i], x[j], y[i], y[j]);
        }
    }

    //punim matricu resenja sa svim euklidskim, posle u graf na pozicije koje treba dodajem veze

    int m;
    scanf("%d", &m);

    int *p= (int*)malloc(m * sizeof(int));
    int *q= (int*)malloc(m * sizeof(int));
    double *vremena = (double*)malloc(m * sizeof(double));

    for(int i = 0; i < m; i++){
        scanf("%d%d%lf", &p[i], &q[i], &vremena[i]);
        graf[p[i]][q[i]] = resenje[p[i]][q[i]] / vremena[i];
    }

    
 

    int A, B;
    scanf("%d%d", &A, &B);
    dijkstra(graf, d, prethodnici, n, A, poseceni);

    for(int i = 0; i < n; i++){
        if(i == B){
            printf("%f", d[i]);
        }
    }

    //vreme

    free(resenje);

    return 0;
}