#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define NEDEFINISANO -1
#define INF 1000000
#define TRUE 1
#define FALSE 0


int trenutniNajmanji(int *d, int *posecen, int n)
{

    int minCvor = NEDEFINISANO;
    int minTezina = INF;
    for(int i=0;i<n;i++)
    {
        if(posecen[i] == FALSE && minTezina > d[i])
        {
            minTezina = d[i];
            minCvor = i;
        }
    }

    return minCvor;
}


void relax(int *d, int *pret ,int **graf, int trenutni, int sledeci)
{
    if(d[sledeci] > d[sledeci] + graf[trenutni][sledeci])
    {
        d[sledeci] = d[sledeci] + graf[trenutni][sledeci];
        pret[sledeci] = trenutni;
    }
}

void dijkstra(int **graf,int *pret,int *prenos,int *d, int *posecen, int n, int s)
{
  
    d[s] = prenos[s];
    for(int i=0;i<n;i++)
    {
        
        int najmanji = trenutniNajmanji(d,posecen,n);
        if(najmanji == NEDEFINISANO) break;
        posecen[najmanji] = TRUE;
        for(int sledeci=0;sledeci<n;sledeci++)
        {
            if(graf[najmanji][sledeci]!=INF && posecen[sledeci] == FALSE)
            {
                relax(d,pret,graf,najmanji,sledeci);
            }
        }
    }
}



int main()
{

    int n,m;
    scanf("%d",&n);

    int **graf = (int**)malloc(n*sizeof(int*));
    for(int i=0;i<n;i++)
    {
        graf[i] = (int*)malloc(n*sizeof(int));
    }

    int *d = (int*)malloc(n*sizeof(int*));
    int *pret = (int*)malloc(n*sizeof(int*));
    int *posecen = (int*)malloc(n*sizeof(int*));


    int *x = (int*)malloc(n*sizeof(int*));
    int *y = (int*)malloc(n*sizeof(int*));
    int *t = (int*)malloc(n*sizeof(int*));

    for(int i=0;i<n;i++)
    {
        scanf("%d %d %d",&x[i],&y[i],&t[i]);
    }

    for(int i=0;i<n;i++)
    {
        for(int j=0;j<n;j++)
        {
            graf[i][j] = INF;
        }
        d[i] = INF;
        pret[i] = NEDEFINISANO;
        posecen[i] = FALSE;
    }

    
    

    

    scanf("%d",&m);
    for(int i=0;i<m;i++)
    {
        int p,q;
        double v;
        scanf("%d%d%lf",&p,&q,&v);
        double dx = x[p] - x[q];
        double dy = y[p] - y[q];
        double duzina = sqrt(dx*dx+dy*dy);
        double vreme = duzina /v;

        graf[p][q] = vreme;
        graf[q][p] = vreme;
    }



    int A,B;
    scanf("%d%d",&A,&B);
    
    dijkstra(graf,pret,t,d,posecen,n,A);
    double konacno = d[B] + t[B];
    printf("%.2lf\n",konacno);

    return 0;
}