#include<stdio.h>
#include<stdlib.h>
#include<math.h>


#define NEDEFINISANO -1
#define TRUE 1
#define FALSE 0

typedef struct{
	int x;
	int y;
	int t;
	float d;
}Ruter;

typedef struct{
	int p;
	int q;
	float d;
	float v;
}Veza;

/*
float rastojanjeKoordinata(Ruter a,Ruter b)
{
	return sqrt( (a.x-b.x)*(a.x-b.x) + (a.y-b.y)*(a.y-b.y) );
}
**/
float rastojanjeKoordinate(int x)
{
	return sqrt((0-x)*(0-x));
}

float euklidskoRastojanje(Veza a,Veza b)
{
	return sqrt( (a.p-b.p)*(a.p-b.p) + (a.q-b.q)*(a.q-b.q) );
}

int jeManji(int x,int y)
{
	if(x==NEDEFINISANO) return FALSE;
	if(y==NEDEFINISANO) return TRUE;
	return x<y;
}

int nadjiMinimum(int *obidjen,float *d,int n)
{
	int min=NEDEFINISANO;
	int minCvor=NEDEFINISANO;
	for(int i=0;i<n;i++)
	{
		if(obidjen[i]==FALSE && jeManji(d[i],min))
		{
			min=d[i];
			minCvor=i;
		}
	}
	
	return minCvor;
}

void dijkstra(Ruter **graf,int *obidjen,float *d,int n,Veza *veze,Ruter *ruteri)
{
	int u;
	for(int i=0;i<n;i++)
	{
		u=nadjiMinimum(obidjen,d,n);
		if(u==NEDEFINISANO) break;
		obidjen[u]=TRUE;
		
		for(int v=0;v<n;v++)
		{
			if(graf[u][v].d!=NEDEFINISANO && obidjen[v]==FALSE )
			{
				float vreme;
				float rastojanje=veze[v].d;
				float brzina=veze[v].v;
				vreme=rastojanje/brzina;
				
				//int ukupnoVreme=vreme+graf[u].t;
				
				int ukupnoVreme=vreme+ruteri[u].t+ruteri[v].t;
				
				if(jeManji(d[u]+ukupnoVreme,d[v]))
				{
					d[v]=d[u]+vreme;
					
				}
			}
		}
		
	}
}



int main()
{
	int n,i,j;
	scanf("%d",&n);
	
	Ruter *ruteri=(Ruter*)malloc(n*sizeof(Ruter));

	Ruter **graf=(Ruter**)malloc(n*sizeof(Ruter*));
	for(i=0;i<n;i++)
		graf[i]=(Ruter*)malloc(n*sizeof(Ruter));
	/*
	int **graf=(int**)malloc(n*sizeof(int*));
	for(i=0;i<n;i++)
		graf[i]=(int*)malloc(n*sizeof(int));
		* 
	
	*/
	for(i=0;i<n;i++)
		for(j=0;j<n;j++)
			graf[i][j].d=NEDEFINISANO;
			
	float *d=(float*)malloc(n*sizeof(float));
	int *obidjen=(int*)malloc(n*sizeof(int));
	
	for(i=0;i<n;i++)
	{
		d[i]=NEDEFINISANO;
		obidjen[i]=FALSE;
	}
	
	
	int x,y,t;
	for(i=0;i<n;i++)
	{
		scanf("%d%d%d",&x,&y,&t);
		//ruteri[i].x=x;
		ruteri[i].x=rastojanjeKoordinate(x);
		//ruteri[i].y=y;
		ruteri[i].x=rastojanjeKoordinate(x);
		ruteri[i].t=t;
		//ruteri[i].d=rastojanjeKoordinata(ruteri[i].x,ruteri[i].y);
	}
	
	int m;
	scanf("%d",&m);
	
	Veza *veze=(Veza*)malloc(m*sizeof(Veza));
	
	int p,q;
	float v;
	for(j=0;j<m;j++)
	{
		scanf("%d%d%f",&p,&q,&v);
		veze[i].p=p;
		veze[i].q=q;
		veze[i].v=v;
		veze[i].d=euklidskoRastojanje(veze[i],veze[i]);
		graf[p][q].d=veze[i].d;
	}
	
	int A,B;
	scanf("%d%d",&A,&B);
	
	d[A]=0;
	
	dijkstra(graf,obidjen,d,n,veze,ruteri);
	
	/*
	int rastAB;
	if(d[B]!=NEDEFINISANO)
	{
		rastAB=d[B];
	}
	
	//float suma=rastAB+ruteri[A].t+ruteri[B].t;
	* */
	float ymin=d[B];
	printf("%.2f",ymin);
	
	return 0;
}
