#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define INF -1.0
#define FALSE 0
#define TRUE 1

typedef struct{
    double x;
    double y;
    double vreme;
}Ruter;

double rastojanje(Ruter r1, Ruter r2){
    return sqrt((r2.x - r1.x) * (r2.x - r1.x) + (r2.y - r1.y) * (r2.y - r1.y));
}

int jeManji(double a, double b){
    if(a == INF) return FALSE;
    if(b == INF) return TRUE;

    return a < b;
}

void nadjiNajmanji(double **graf, int *preth, double *dist, int u, int v){
    if(jeManji(graf[u][v] + dist[u], dist[v])){
        dist[v] = graf[u][v] + dist[u];
        preth[v] = u;
    }
}

void dijkstra(double **graf, double *vremena, int *preth, int *obidjen,int start, int m){
    for(int i = 0; i <= start; i++){
        for(int j = 0; j < m; j++){
            if(graf[i][j] != INF && !obidjen[j]){
                nadjiNajmanji(graf, preth, vremena, i, j);
                obidjen[j] = TRUE;
            }
        }
    }
}

int main(){
    int n;
    scanf("%d", &n);

    Ruter *ruteri = (Ruter*)malloc(n * sizeof(Ruter));
    for(int i = 0; i < n; i++){
        double x, y, vreme;
        scanf("%lf%lf%lf", &ruteri[i].x, &ruteri[i].y, &ruteri[i].vreme);
    }

    int m;
    scanf("%d", &m);
    double **graf = (double**)malloc(m * sizeof(double*));
    for(int i = 0; i < m; i++){
        graf[i] = (double*)malloc(m * sizeof(double));
        for(int j = 0; j < m; j++)
            graf[i][j] = INF;
    }

    for(int i = 0; i < m; i++){
        int p, q;
        double v;
        scanf("%d%d%lf", &p, &q, &v);
        graf[p][q] = v;
    }

    

    int A, B;
    scanf("%d%d", &A, &B);

    double *vremena = (double*)malloc(n * sizeof(double));
    int *obidjen = (int*)malloc(n * sizeof(int));
    int *preth = (int*)malloc(n * sizeof(int));
    
    for(int i = 0; i < n; i++){
        vremena[i] = INF;
        obidjen[i] = FALSE;
        preth[i] = -1;
    }
    vremena[A] = 0;

    for(int i = 0; i < m; i++){
        for(int j = 0; j < m; j++){
            if(graf[i][j] != INF){
                graf[i][j] = rastojanje(ruteri[i], ruteri[j]) / graf[i][j] + ruteri[i].vreme + ruteri[j].vreme;
            }
        }
    }

    
    dijkstra(graf, vremena, preth, obidjen, A, m);
    
    printf("%.2lf\n", vremena[B]);



    return 0;
}

