#pretpostavka jedna utakmica po sezoni za dva tima

from pyspark import SparkConf, SparkContext
import sys
import os
import datetime

conf = SparkConf().setMaster("local").setAppName("Vojin")
sc = SparkContext(conf = conf)

def getWinner(x):
    if x[1][1][0][1] > x[1][1][1][1]:
        x[1][1][0][0]
    return x[1][1][1][0]

def getLoser(x):
    if x[1][1][0][1] > x[1][1][1][1]:
        x[1][1][1][0]
    return x[1][1][0][0]

def getMaxKey(x, y):
    if x[1][1] == max(x[1][1], y[1][1]):
        return x[1][0]
    return y[1][0]

def readCsv(path):
    data = sc.textFile(path).map(lambda line: line.split(";"))
    return data

timovi = readCsv("./Ulaz/timovi.csv")
utakmice = readCsv("./Ulaz/utakmice.csv")
golovi = readCsv("./Ulaz/golovi.csv")
sezone = readCsv("./Ulaz/sezone.csv")

# tim ((tim, utakmice), 1)
goloviPoUtakmiciPoTimu = golovi.map(lambda x: ((x[2],x[1]), 1))
# print(goloviPoUtakmici.collect())

# tim ((tim, utakmice), 5)
ukupnoGolova = goloviPoUtakmiciPoTimu.reduceByKey(lambda x, y: x+y)
# print(ukupnoGolova.collect())

utakmicaGolovi = ukupnoGolova.map(lambda x: (x[0][1], (x[0][0], x[1])))

# (utakmica, (tim, 5),(tim,4))
utakmicaGoloviPar = utakmicaGolovi.join(utakmicaGolovi).filter(lambda x: x[1][0][0] != x[1][1][0])
# print(utakmicaGoloviPar.collect())

#(sezona, (pobednik, gubitnik))
utakmiceSaSezonama = utakmice.map(lambda x: (x[0], x[1])).join(utakmicaGoloviPar).filter(lambda x: x[1][1][0][1] != x[1][1][1][1]).map(lambda x: (x[1][0], (getWinner(x), getLoser(x))))
# print(utakmiceSaSezonama.collect())
#((pobednik, gubitnik), (sezona, 0))
pobednikPoSezoni = utakmiceSaSezonama.map(lambda x: (x[1], (int(x[0]), 0)))
print(pobednikPoSezoni.collect())

ukupnoUzastopnih = pobednikPoSezoni.reduceByKey(lambda x,y: (max(x[1][0], y[1][0]), x[1][1]+y[1][1]) if abs(x[1]-y[1]) == 1 else (getMaxKey(x,y), max(x[1][1], y[1][1])))
print(ukupnoUzastopnih.collect())


# pobednik = ukupnoUzastopnih.reduceByKey(lambda)

# .map(lambda x: (x[1]))

# utakmicaGoloviPar.map(lambda x: (x[1][0][0]))


