#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX 100

// UTAKMICE SU ODIGRANE HRONOLOSKI

char imeTima[MAX][20];
int timoviUtakmice[MAX][MAX];
int pobednikUtakmice[MAX];
int goloviDomacinaNaUtakmici[MAX];
int goloviGostaNaUtakmici[MAX];
int serijaPobedaTima1NadTimom2[MAX][MAX];

void ucitajTimove() {
    char line[256];

    FILE *timoviF = fopen("timovi.csv", "r");

    while(fgets(line, 256, timoviF)) {
        int idTima;
        char ime[20];
        sscanf(line, "%d;%[^\n|\t|\r]", &idTima, ime);

        strcpy(imeTima[idTima], ime);
    }
    fclose(timoviF);
}

void ucitajUtakmice() {
    char line[256];

    FILE *utakmiceF = fopen("utakmice.csv", "r");

    while(fgets(line, 256, utakmiceF)) {
        int idUtakmice, idSezone, idDomacina, idGosta;
        
        sscanf(line, "%d;%d;%d;%d", &idUtakmice, &idSezone, &idDomacina, &idGosta);
        
        timoviUtakmice[idDomacina][idGosta] = idUtakmice;
    }
    fclose(utakmiceF);
}

void racunajPobede() {
    char line[256];

    FILE *goloviF = fopen("golovi.csv", "r");

    while(fgets(line, 256, goloviF)) {
        int idGola, idUtakmice, idTima, idIgraca;
        
        sscanf(line, "%d;%d;%d;%d", &idGola, &idUtakmice, &idTima, &idIgraca);
        
        int goloviDomacin = 0, goloviGost = 0;
        for(int i = 0; i < MAX; i++) {
            for(int j = 0; j < MAX; j++) {
                if (timoviUtakmice[i][j] == idUtakmice) {
                    if (i == idTima) {
                        goloviDomacinaNaUtakmici[idUtakmice]++;
                    } else if (j == idTima) {
                        goloviGostaNaUtakmici[idUtakmice]++;
                    }
                }
            }
        }
    }
    fclose(goloviF);

    for(int i = 0; i < MAX; i++) {
        if (goloviDomacinaNaUtakmici[i] > goloviGostaNaUtakmici[i]) {
            pobednikUtakmice[i] = 1;
        } else if(goloviDomacinaNaUtakmici[i] < goloviGostaNaUtakmici[i] ) {
            pobednikUtakmice[i] = 2;
        } else {
            pobednikUtakmice[i] = 0;
        }
    }

    for(int i = 0; i < MAX; i++) {
        for(int j = 0; j < MAX; j++) {
            for(int idUtakmice = 0; idUtakmice < MAX; idUtakmice++) {
                if (idUtakmice == timoviUtakmice[i][j]) {
                    if (pobednikUtakmice[idUtakmice] == 1) {
                        serijaPobedaTima1NadTimom2[i][j]++;
                        break;
                    } else if (pobednikUtakmice[idUtakmice] == 2) {
                        serijaPobedaTima1NadTimom2[j][i]++;
                        break;
                    }
                }
            }
        }
    }
}

void mapFaza(char const *fajl) {
    char line[256];

    FILE *fajlF = fopen(fajl, "r");

    while(fgets(line, 256, fajlF)) {
        int idGola, idUtakmice, idTima, idIgraca;
        
        sscanf(line, "%d;%d;%d;%d", &idGola, &idUtakmice, &idTima, &idIgraca);

        int goloviDomacin = 0, goloviGost = 0;
        for(int i = 0; i < MAX; i++) {
            for(int j = 0; j < MAX; j++) {
                if (timoviUtakmice[i][j] == idUtakmice) {
                    if (i == idTima) {
                        goloviDomacinaNaUtakmici[idUtakmice]++;
                    } else if (j == idTima) {
                        goloviGostaNaUtakmici[idUtakmice]++;
                    }
                }
            }
        }
    }
    fclose(fajlF);

    for(int i = 0; i < MAX; i++) {
        printf("%d;%d;%d\n", i, goloviDomacinaNaUtakmici[i], goloviGostaNaUtakmici[i]);
    }
}

void reduceFaza() {
    char line[256];

    FILE *svi = fopen("svi.csv", "r");

    while(fgets(line, 256, svi)) {
        int idUtakmice, brGolovaDomacina, brGolovaGosta;
        
        sscanf(line, "%d;%d;%d", &idUtakmice, &brGolovaDomacina, &brGolovaGosta);
        
        if (brGolovaDomacina > brGolovaGosta) {
            pobednikUtakmice[idUtakmice] = 1;
        } else if (brGolovaDomacina < brGolovaGosta) {
            pobednikUtakmice[idUtakmice] = 2;
        } else {
            pobednikUtakmice[idUtakmice] = 0;
        }
    }
    fclose(svi);

    for(int i = 0; i < MAX; i++) {
        for(int j = 0; j < MAX; j++) {
            for(int idUtakmice = 0; idUtakmice < MAX; idUtakmice++) {
                if (idUtakmice == timoviUtakmice[i][j]) {
                    if (pobednikUtakmice[idUtakmice] == 1) {
                        serijaPobedaTima1NadTimom2[i][j]++;
                        break;
                    } else if (pobednikUtakmice[idUtakmice] == 2) {
                        serijaPobedaTima1NadTimom2[j][i]++;
                        break;
                    }
                }
            }
        }
    }

    int maxPobeda = -1;
    int ekipa1 = -1;
    int ekipa2 = -1;

    for(int i = 0; i < MAX; i++) {
        for(int j = 0; j < MAX; j++) {
            if(serijaPobedaTima1NadTimom2[i][j] && serijaPobedaTima1NadTimom2[i][j] > maxPobeda) {
                maxPobeda = serijaPobedaTima1NadTimom2[i][j];
                ekipa1 = i;
                ekipa2 = j;
            }
        }
    }

    FILE *najduzaSerijaF = fopen("najduzaSerija.csv", "w");

    fprintf(najduzaSerijaF, "%d;%d;%d\n", ekipa1, ekipa2, maxPobeda);

    fclose(najduzaSerijaF);
}

int main(int argc, char const *argv[]) {
    ucitajTimove();
    ucitajUtakmice();
    racunajPobede();

    if (argc > 2) {
        mapFaza(argv[1]);
    } else {
        reduceFaza();
    }


    for(int i = 0; i < MAX; i++) {
        if (pobednikUtakmice[i]) {
            printf("%d - %d\n", i, pobednikUtakmice[i]);
        }
    }
    printf("-------------------------------\n");
    for(int i = 0; i < MAX; i++) {
        for(int j = 0; j < MAX; j++) {
            if(serijaPobedaTima1NadTimom2[i][j]) {
                printf("%d - %d, %d\n", i, j, serijaPobedaTima1NadTimom2[i][j]);
            }
        }
    }

    return 0;
}