#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct tim{
    int id;
    char naziv[50];
}Tim;

typedef struct utakmica{
    int id;
    int id_sezone;
    int id_domacina;
    int id_gosta;
}Utakmica;

typedef struct golovi{
    int id;
    int id_utakmice;
    int id_tima;
    int id_igraca;
}Golovi;

int main(int argc, char **argv)
{
    FILE *f = fopen(argv[1],"r");
    //FILE *f = fopen("timovi.csv","r");
    Tim t;
    Utakmica u;
    Golovi g;
      
    FILE *utakmice_file = fopen("utakmice.csv","r");
    FILE *golovi_file = fopen("utakmice.csv","r");

    fscanf(f,"%d;%s",&t.id,t.naziv);
    //printf("%d\n%s\n",tim.id,tim.naziv);
    int serija_pobeda=0;
    int serija_pobeda_max=-1;
    int id_protivnika=-1;
    while(fscanf(utakmice_file,"%d;%d;%d;%d",&u.id,&u.id_sezone,&u.id_domacina,&u.id_gosta)==4)
    {
        //uzmemo jednu utakmicu 
        //gledamo da li je nas tim igrao u njoj (domacin/gost)
        // ako nije preskacemo tu utakmicu
        if(!((t.id == u.id_domacina) || (t.id == u.id_gosta))) continue;
        
        //postavljamo id protivnika
        // da bismo znali protiv koga pratimo niz
        // i proveravamo da li vec nismo oznacili protivnika protiv koga pratimo niz
        int temp_id=0;
        if(t.id == u.id_domacina )
        {
            temp_id = u.id_gosta;
        }
        else if(t.id == u.id_gosta )
        {
            temp_id = u.id_domacina;
        }
        //proveravamo da li je selektovana protivnicka ekipa

        if(id_protivnika == -1)
        {
            id_protivnika = temp_id;

        }
        // ukoliko smo naisli na novu protivnicku ekpu
        // OVO RADI SAMO AKO JE TABELA UTAKMICE U FORMATU GDE SU HRONOLOSKI ISPISANE SVE UTAKMICE PROTIV JEDNE EKIPE
        // tj. ako na ovoj utakmici nas protivnik ima id 3, a ucitavanjem sledece utakmice dobijemo da nam protivnik ima id 4
        // pretpostavljamo da su to sve utakmice naseg tima protiv protivnika sa id 3
        else if(id_protivnika != temp_id)
        {
            id_protivnika=temp_id;
            //kraj serije
            if(serija_pobeda > serija_pobeda_max)
            {
                //zapamtimo seriju ukoliko je najbolja
                serija_pobeda_max=serija_pobeda;
            }
            serija_pobeda=0;
            

        }

        //ako nas tim igra na ovoj utakmici ali ne protiv oznacenog protivnika
        // preskacemo tu utakmicu
        if(!((id_protivnika == u.id_domacina) || (id_protivnika == u.id_gosta))) continue;

        int nas_tim=0;
        int protivnik=0;

        while(fscanf(golovi_file,"%d;%d;%d;%d",&g.id,&g.id_utakmice,&g.id_tima,&g.id_igraca)==4)
        {
            //gledamo da li je gol postignut na ovoj utakmici
            // ako nije preskacemo
            if(u.id != g.id_utakmice) continue;

            if(t.id == g.id_tima)
            {
                // ako je nas tim taj koji postize gol
                nas_tim++;

            }
            else
            {
                //protivnik postigao gol
                protivnik++;

            }

        }
        //ukoliko je nas tim postigao vise golova na utakmici
        // znaci da je pobedio tu utakmicu = povecavamo seriju pobeda
        if(nas_tim>protivnik)
        {
            serija_pobeda++;
            nas_tim=0;
            protivnik=0;
        }
        else
        {
            //nas tim je izgubio
            //kraj serije
            if(serija_pobeda > serija_pobeda_max)
            {
                //zapamtimo seriju ukoliko je najbolja
                serija_pobeda_max=serija_pobeda;
            }
            serija_pobeda=0;
            nas_tim=0;
            protivnik=0;

        }

        //vracamo fajl golovi na pocetak 
        rewind(golovi_file);

    }
    // ispisujemo najduzu seriju pobeda jednog tima
    // protiv istog protivnika
    printf("TIM: %s, serija pobeda: %d\n, protiv tima(ID): %d",t.naziv,serija_pobeda_max,id_protivnika);

    fclose(f);
    fclose(utakmice_file);
    fclose(golovi_file);

    return 0;
}