from pyspark import SparkContext, SparkConf
import csv 

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)

def readCSV(filepath):
    rdd = sc.textFile(filepath).mapPartitions(lambda x : csv.reader(x, delimiter = ";"))
    return rdd


utakmice = readCSV("Ulaz/utakmice.csv")

#id_domacina id_utakmice
utakmica_domacin = utakmice.map(lambda x : (x[2], x[0]))

#id_gosta id_utakmice
utakmica_gost = utakmice.map(lambda x : (x[3], x[0]))


golovi = readCSV("Ulaz/golovi.csv")

#id_tima id_utakmice
golovi_rdd = golovi.map(lambda x : (x[2], x[1]))

#id_domacina id_utakmice 
joinDomacinGolovi = utakmica_domacin.join(golovi_rdd)

#id_domacina id_utakmice 
joinGostGolovi = utakmica_gost.join(golovi_rdd)

goloviD = joinDomacinGolovi.map(lambda x : ((x[0], x[1]),1))

goloviDomacin = goloviD.reduceByKey(lambda x,y : x+y)

goloviG = joinGostGolovi.map(lambda x : ((x[0], x[1]),1))

goloviGost = goloviG.reduceByKey(lambda x,y : x+y)



print("\n" + "---------------------------------------------------------------------")
#print(goloviGost.collect())
print("DOMACIN")
#print(goloviD.collect())
print("GOST")
print(joinGostGolovi.collect())
print("\n" + "---------------------------------------------------------------------")
print("DOMACIN")
#print(goloviDomacin.collect())
print("\n" + "---------------------------------------------------------------------")
