from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)

timovi = sc.textFile("timovi.csv").map(lambda x: x.split(';')).map(lambda x: (int(x[0]),x[1]))
#(idTima,nazivTima) 
#[(1, 'Crvena zvezda'), (2, 'Radnicki KG'), (3, 'Vojvodina'), (4, 'Partizan')]

utakmice = sc.textFile("utakmice.csv").map(lambda x: x.split(';')).flatMap(lambda x: [(int(x[0]),int(x[2])),(int(x[0]),int(x[3]))])
#((idUtakmice,idDomacina),(idUtakmice,idGosta))
#[(1, 1), (1, 2), (2, 1), (2, 3), (3, 1), (3, 4), (4, 2), (4, 1), (5, 2), (5, 4), (6, 3), (6, 2), (7, 4), (7, 2), (8, 3), (8, 4), (9, 4), (9, 3)]

golovi = sc.textFile("golovi.csv").map(lambda x: x.split(';')).map(lambda x:(int(x[1]),int(x[2])))
#(idUtakmice,idTima) - tim koji je dao gol
#[(1, 1), (1, 1), (1, 2), (2, 1), (2, 1), (2, 3)]

goloviPoTimu = golovi.join(utakmice).filter(lambda x: x[1][0]==x[1][1]).map(lambda x: ((x[0],x[1][0]),1)).reduceByKey(lambda x,y:x+y)
#((idUtakmice,idTima),goloviTimaNaUtakmici)
#[((1, 1), 2), ((2, 1), 2), ((2, 3), 1), ((1, 2), 1)]

pobednik = goloviPoTimu.map(lambda x: (x[0][0],(x[0][1],x[1]))).reduceByKey(lambda x,y: x[0] if x[1] > y[1] else y[0])
#(idUtakmice,idPobednika)
#[(2, 1), (1, 1)]

pobednikGubitnik = pobednik.join(utakmice).filter(lambda x: x[1][0]!=x[1][1]).map(lambda x: ((x[1][0],x[1][1]),1)).reduceByKey(lambda x,y:x+y)
#(idPobednika,idGubitnika,pobedaUNizu)
#[((1, 2), 1), ((1, 3), 1)]

maxPobedaUNizu = pobednikGubitnik.map(lambda x: x[1]).max()
timSaNajvecimNizom = pobednikGubitnik.filter(lambda x: x[1]==maxPobedaUNizu).map(lambda x: x[0][0]).first()

najboljiTim = timovi.filter(lambda x: x[0]==timSaNajvecimNizom).map(lambda x: x[1])
print(najboljiTim.collect())