#!/bin/bash
rm -rf *.out *.in
rm -rf input_*
dos2unix -q ulaz/golovi.scv
dos2unix -q ulaz/timovi.csv
dos2unix -q ulaz/utakmice.csv

awk -F ';' '{print $3 " " $4}' ulaz/utakmice.csv | sort -n > timovi.txt

n_nodes=$(cat timovi.txt | wc -l)

split -l 1 timovi.txt input_

i=1
for file in input_*
do
	mv $file "$i.in"
	(($i+1))	
done

gcc -std=c99 main.c -o main
chmod +x job.slurm

job_id=$(sbatch --array=1-$i job.slurm | awk '{print $4}')

while squeue -j $job_id -h | grep -q .
do
	sleep 2
done

echo "Job finished $job_id"
