from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
context = SparkContext(conf = conf)

def readFromCsv(path):
    readRDD = context.textFile(path).mapPartitions(lambda x : csv.reader(x, delimiter=';'))
    return readRDD

utakmice = readFromCsv('utakmice.csv')
golovi = readFromCsv('golovi.csv')

#jedna utakmica jedna sezona

tekmeDom = utakmice.map(lambda x : ( (x[0],x[2]), (x[3],x[1]) )) #idu,iddom , (idg,ids)
golDom = golovi.map(lambda x : ( (x[1],x[2]) , 1 )) #idu,idtim, 1


tekmeDom = tekmeDom.join(golDom).map(lambda x : ( (x[1][0][1] ,x[0][0], x[0][1] , x[1][0][0]), 1 )) #ids,idu,iddom,idg,(1)
tekmeDom = tekmeDom.reduceByKey(lambda x,y : x+y ) #dati golovi gostu kao dom  

tekmeGost = utakmice.map(lambda x : ( (x[0],x[3]), (x[2],x[1]))) #idu,idg , (iddom, ids)
golGost = golovi.map(lambda x : ( (x[1],x[2]) , 1 )) #idu,idtim, 1

tekmeGost = tekmeGost.join(golGost).map(lambda x : ( (x[1][0][1] ,x[0][0], x[0][1] , x[1][0][0]), 1 )) #ids,idu,iddom,idgost,(1)
tekmeGost = tekmeGost.reduceByKey(lambda x,y : x+y)
tekmeGost = tekmeGost.map(lambda x : ( (x[0][0], x[0][1], x[0][3], x[0][2]) , x[1] ))

rezultatiDom = tekmeDom.join(tekmeGost) #ids,idu,iddom,idgost,(1, 4)

pobedeDomacina = rezultatiDom.filter(lambda x: x[1][0] > x[1][1])
pobedeDomacina = pobedeDomacina.map(lambda x: ((x[0][0] ,x[0][2],x[0][3]), 1) ) #ids,idd,idg
pobedeDomacina = pobedeDomacina.map(lambda x : ( (x[0][1] , x[0][2]) , x[0][0] ))

nizPobedaDom = pobedeDomacina.reduceByKey(lambda x,y : x[1] == y[1]-1) #iddom, #idgost, brojPobeda
# nizPobedaDom = pobedeDomacina.reduceByKey(lambda x,y : x+y, 1)
najbolji = nizPobedaDom.reduce(lambda x,y: x>y)

nizPobedaDom.saveAsTextFile('najbolji')



# tekmeGost = utakmice.map(lambda x : ( (x[0],x[3]), x[2] )) #idu,idgost , (iddom)
# golGost = golovi.map(lambda x : ( (x[1],x[2]) , 1 )) #idu,idtim, 1

# tekmeGost = tekmeGost.join(golGost).map(lambda x : ( (x[0][0], x[1][0] , x[0][1]), 1 )) #idu,idgost,iddom,(1)
# tekmeGost = tekmeGost.reduceByKey(lambda x,y : x+y )

# tekmeDom = utakmice.map(lambda x : ( (x[0],x[2]), x[3] )) #idu,iddome , (idgost)
# golDom = golovi.map(lambda x : ( (x[1],x[2]) , 1 )) #idu,idtim, 1

# tekmeGost = tekmeDom.join(golDom).map(lambda x : ( (x[0][0], x[0][1] , x[1][0]), 1 )) #idu,idg,iddom,(1)
# tekmeGost = tekmeGost.join(golGost).map(lambda x : ( (x[0][0], x[1][0] , x[0][1]), 1 )) #idu,idgos,iddom,(1)

# rezultatiDom = tekmeDom.join(tekmeGost) #idu,iddom,idgost,(1, 4)

# pobedeDomacina = rezultatiDom.filter(lambda x: x[1][0] > x[1][1])
# pobedeDomacina = pobedeDomacina.map(lambda x: (x[0][1],x[0][2]), 1) #iddom,idgos,(1)