#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define MAX 100

char nazivTimova[MAX][100];
int domacin[MAX];
int gost[MAX];
int golDom[MAX]={0};
int golGost[MAX]={0};
void ucitajTimove()
{
    char line[256];
    FILE *f=fopen("timovi.csv","r");
    if(!f) return;
    while(fgets(line,256,f))
    {
        int id;
        char naziv[50];
        sscanf(line,"%d;%[^;\n]",&id,naziv);
        strcpy(nazivTimova[id],naziv);
    }
    fclose(f);
}
void ucitajUtakmice()
{
    char line[256];
    FILE *f=fopen("utakmice.csv","r");
    if(!f) return;
    while(fgets(line,256,f))
    {
        int idu,idSez,idD,idG; 
        sscanf(line,"%d;%d;%d;%d",&idu,&idSez,&idD,&idG);
        domacin[idu]=idD;
        gost[idu]=idG;
        printf("%d;%d;%d;%d\n",idu,idSez,idD,idG);
    }
    fclose(f);
}
void ucitajGolove()
{
    char line[256];
    FILE *f=fopen("golovi.csv","r");
    if(!f) return;
    while(fgets(line,256,f))
    {
        int idgola,idut,idtim,idigr;
        sscanf(line,"%d;%d;%d;%d",&idgola,&idut,&idtim,&idigr);
        if(idtim==domacin[idut])golDom[idtim]++;
        else
        golGost[idtim]++;
    }
    fclose(f);
}
void map(char *fajl)
{
    char line[256];

    FILE *f=fopen(fajl,"r");
    if(!f) return;
    while(fgets(line,256,f))
    {
        
        int idU,idSEz,idD,idG;
        sscanf(line,"%d;%d;%d;%d",&idU,&idSEz,&idD,&idG);
        int gd=golDom[idU];
        int gg=golGost[idU];
        if(gd=gg) continue;
        int pob=(gd>gg)? idD:idG;
        int por=(gd>gg)? idG:idD;
        printf("%d %s %d %s\n",pob,nazivTimova[pob],por,nazivTimova[por]);

    }
    fclose(f);

}
typedef struct
{
    int pob;
    int por;
    int lasU;
    int cur;
    int best;
}Serija;
Serija serije[MAX*2];
int nser=0;
int nadjiIndex(int pob,int por)
{
    for(int i=0;i<nser;i++)
    if(serije[i].pob==pob && serije[i].por==por) return i;
    serije[nser].pob=pob;
    serije[nser].por=por;
    serije[nser].lasU=-1;
    serije[nser].cur=0;
    serije[nser].best=0;
    nser++;
    return nser-1;
}

void reduceFaza()
{
    char line[256];
    FILE *f=fopen("svi.txt","r");
    if(!f) return;
    while(fgets(line,256,f))
    {
        int pob,por,idU;
        char np[100],nr[100];
        sscanf(line,"%d,%[^,],%d,%[^,],%d",&pob,np,&por,nr,&idU);
        int idx=nadjiIndex(pob,por);

        if(serije[idx].lasU!=-1 &&idU==serije[idx].lasU+1)
        {
            serije[idx].cur=1;
        }
        else
        {
            serije[idx].cur++;
        }
        serije[idx].lasU=idU;
        if(serije[idx].cur>serije[idx].best)
        {
            serije[idx].best=serije[idx].cur;
        }
    }
    fclose(f);
    int bestlen=-999;
    int bestP=-1;
    int bestR=-1;
    for(int i=0;i<nser;i++)
    {
        if(serije[i].best>bestlen)
        {bestlen=serije[i].best;
        bestP=serije[i].pob;
        bestR=serije[i].por;
        }
    }
    FILE *out=fopen("najduzaserija.csv","w");
    if(!out) return;
    if(bestlen!=-9999)
    {
        fprintf(out,"%d,%s,%d,%s,%d\n",bestP,nazivTimova[bestP],bestR,nazivTimova[bestR],bestlen);
    }
    fclose(out);
}
int main(int argc,char * argv[])
{
    ucitajTimove();
    ucitajUtakmice();
    ucitajGolove();
    map("utakmice.csv");
    if(argc>1) map((char*)argv[1]);
    else
    reduceFaza();
}