from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)

utakmice = sc.textFile("Ulaz/utakmice.csv").mapPartitions(lambda x: csv.reader(x, delimiter=';')).map(lambda x: (x[1], (x[0], x[2], x[3])))
print(utakmice.collect())
#(id_utakmice, (id_sezone, id_domacina, id_gosta))

golovi = sc.textFile("Ulaz/golovi.csv").mapPartitions(lambda x: csv.reader(x, delimiter=';')).map(lambda x: (x[1], x[2]))
print(golovi.collect())

golovi_utakmice = golovi.join(utakmice)
#(id_utakmice, (id_tima, (id_sezone, id_domacina, id_gosta)))
print(golovi_utakmice.collect())


