from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
context = SparkContext(conf = conf)


def readCSV(path):
    rddCSV = context.textFile(path).mapPartitions(lambda x: csv.reader(x, delimiter = ";"))
    return rddCSV

# Исписати тим који има најдужу серију победа против истог противника.

golovi = readCSV("golovi.csv")
# golovi(id, id_utakmice, id_tima, id_igraca)

utakmice = readCSV("utakmice.csv")
# utakmice(id, id_sezone, id_domaćina, id_gosta)

sezona = readCSV("sezona.csv")
# sezona(id, godina)

timovi = readCSV("timovi.csv")
# timovi(id, naziv)

# golovi
# 1;1;1;1 1tekma 2:1 zvezda radnicki
# 2;1;1;2 2tekma 2:1 zvezda vojvodina
# 3;1;2;5 
# 4;2;1;7
# 5;2;1;7
# 6;2;3;1

# utakmice

# 1;1;1;2
# 2;1;1;3
# 3;1;1;4
# 4;1;2;1
# 5;2;2;4
# 6;2;3;2
# 7;2;4;2
# 8;2;3;4
# 9;2;4;3


utakmiceDom = utakmice.map(lambda x: ((x[2], x[0]), (x[1], x[3])))
#(iddomacina,idutakmice), (idsezone, idgost)

utkamiceGost = utakmice.map(lambda x: ((x[3], x[0]),(x[1], x[2])))
#(idgosta, idutakmice), (idsezone, iddomacina)

golovi1 = golovi.map(lambda x: ((x[2], x[1]), 1))
#(idtima, idutakmice), 1

goloviNaUtakmiciDom = utakmiceDom.fullOuterJoin(golovi1).map(lambda x: ((x[0][0], x[0][1]), x[1][1] or 0))
#(iddomacina, idutakmice), ((idsezone, idgost), 1)
#(iddomacina, idutakmice), 1/0

goloviNaUtakmiciGost = utkamiceGost.fullOuterJoin(golovi1).map(lambda x: ((x[0][0], x[0][1]), x[1][1] or 0))
#(idgosta, idutakmice), ((idsezone, iddomacin), 1)
#(idgosta, idutakmice), 1/0

# hronoloski
goloviNaUtakmiciDomUkupno = goloviNaUtakmiciDom.reduceByKey(lambda x, y : x + y).map(lambda x: (x[0][1], (x[0][0], x[1])))
#(iddomacina, idutakmice), brojgolova
#idutakmice, (id domacina, broj golova)


goloviNaUtakmiciGostUkupno = goloviNaUtakmiciGost.reduceByKey(lambda x, y : x + y).map(lambda x: (x[0][1], (x[0][0], x[1])))
#(idgosta, idutakmice), brojgolova
#idutakmice, (id gosta, broj golova)

utakmicaDomGost = goloviNaUtakmiciDomUkupno.join(goloviNaUtakmiciGostUkupno)
#idutakmice, ((iddomacina, brojgolova), (idgosta, brojgolova))


pobedioDom = utakmicaDomGost.filter(lambda x: x[1][0][1]>x[1][1][1]).map(lambda x: (x[1][0][0], (x[0],1)))
#iddomacina, (idutakmice, 1)


pobedioGost = utakmicaDomGost.filter(lambda x: x[1][1][1]>x[1][0][1]).map(lambda x: (x[1][0][0], (x[0],1)))
#idgosta, (idutakmice, 1)

# 2, (1, 1)
# 2, (2, 1)
# 2, (3, 1)

# 2, (4, 1)
# 2, (5, 1)

# 2, (1,1), (4,1)
# 2, (2,1), (4,1)
# 2, (3,1), (4,1)
# 2, (1,1), (5,1)
# 2, (2,1), (5,1)
# 2, (3,1), (5,1)

rez = pobedioDom.reduceByKey(lambda x, y: x[1] + y[1])

timovi = timovi.map(lambda x: (x[0], (x[1])))

rezultat = rez.join(timovi).map(lambda x: (x[0], (x[1][1], x[1][0][1])))
#iddomacina, ((idutakmice, br), ime)







print('\n\n\n\n\n\n\n\n')
rez.saveAsTextFile('resenje.csv')




    