#zadatak prikazuje tim koji je imao najvise pobeda protiv jednog istog protivnika

from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster('local').setAppName('myApp')
context = SparkContext(conf=conf)

def readFromCSV(path):
    rdd = context.textFile(path).mapPartitions(lambda x : csv.reader(x,delimiter= ";"))
    return rdd

timovi = readFromCSV("timovi.csv") #timovi(id, naziv)

golovi = readFromCSV("golovi.csv") #golovi(id, id_utakmice, id_tima, id_igraca)

utakmice = readFromCSV("utakmice.csv") #utakmice(id, id_sezone, id_domaćina, id_gosta)

goloviTimova= golovi.map(lambda x : ((x[1],x[2]),1)).reduceByKey(lambda x,y: x+y) #((idUtakmice,Id tima), brGolova)

utakmice1= utakmice.map(lambda x : ((x[0],x[2]),x[3])).join(goloviTimova) ##((idUtakmice,Idtima1), (idTima2, brGolovaTima1))

utakmice2= utakmice1.map(lambda x : ((x[0][0],x[1][0]),(x[0][1],x[1][1]))).join(goloviTimova) #((idUtakmice,Idtima2), ((idTima1, brGolovaTima1),brGolovaTima2))

utakmiceRezultat = utakmice2.map(lambda x : ((x[1][0][0],x[0][1]),x[1][0][1],x[1][1])) #((idTima1,idTima2),brGolova1, brGolova2)

pobednik = utakmiceRezultat.map(lambda x : (x[0],1) if x[1]>x[2] else ((x[0][1],x[0][0]),1)).reduceByKey(lambda x,y : x+y) #((pobrednik,gubitnik),BrojPobeda)

resenje = pobednik.map(lambda x : (x[0][0],x[1])).reduceByKey(lambda x,y : x if x > y else y) #(timSaNajvisePobeda,brojPobeda)

resenje1 = resenje.join(timovi.map(lambda x : (x[0],x[1]))).map(lambda x : x[1][1]) # NazvivTimaSaNajvisePobeda

resenje1.saveAsTextFile("resenje.csv")




