//Napomena: Uzela sam kao pravilo da se izmedju dva tima moze odigrati samo jedna utakmica po sezoni.
//Takodje, prvi na kojeg naidje sa najvise pobeda njega ispisuje, ne sve.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct{
    int id;
    char naziv[50];
    int brojProtivnika;
    int protivnici[15];
    int serijePobeda[15];
}tim;

typedef struct{
    int idTim1;
    int idTim2;
    int pobedaPrvog[15];
    int pobedaDrugog[15];
    int brojGolova;
}kombinacijaTimova;

typedef struct{
    int id; 
    int idSezone;
    int idDomacina;
    int idGosta;
    int goloviDomacina;
    int goloviGosta;
    int pobedio;
}utakmica;

int main(){
    FILE* FTimovi = fopen("timovi.csv", "r");
    FILE* FUtakmice = fopen("utakmice.csv", "r");
    FILE* FGolovi = fopen("golovi.csv", "r");

    int brojTimova = 0;
    tim timovi[20];

    int id;
    char naziv[50];

    while (fscanf(FTimovi, "%d;%50[^\n]", &id, naziv) == 2){
        size_t len = strlen(naziv);
        if(naziv[len-1] != '\0') naziv[len-1] = '\0';

        timovi[brojTimova].id = id;
        timovi[brojTimova].brojProtivnika = 0;
        strcpy(timovi[brojTimova].naziv, naziv);
        brojTimova++;
    }

    utakmica utakmice[50];
    int brojUtakmica = 0;

    int i1, i2, i3, i4;

    while (fscanf(FUtakmice, "%d;%d;%d;%d", &i1, &i2, &i3, &i4 ) == 4){
        utakmice[brojUtakmica].id = i1;
        utakmice[brojUtakmica].idSezone = i2;
        utakmice[brojUtakmica].idDomacina = i3;
        utakmice[brojUtakmica].idGosta = i4;
        utakmice[brojUtakmica].goloviDomacina = 0;
        utakmice[brojUtakmica].goloviGosta = 0;
        brojUtakmica++;
    }

    while (fscanf(FGolovi, "%d;%d;%d;%d", &i1, &i2, &i3, &i4 ) == 4){
        for(int i = 0 ; i < brojUtakmica ; i++){
            if(i2 == utakmice[i].id){
                if(i3 == utakmice[i].idDomacina) 
                {
                    utakmice[i].goloviDomacina++;
                    break;
                }
                if(i3 == utakmice[i].idGosta) 
                {
                    utakmice[i].goloviGosta++;
                    break;
                }
            }
        } 
    }

    int brojKombinacija = 0;
    kombinacijaTimova KombinacijeTimova[50];
    for(int i = 0 ; i < brojTimova-1 ; i++) 
    {
        for(int j = i+1 ; j < brojTimova ; j++){
            KombinacijeTimova[brojKombinacija].idTim1 = timovi[i].id;
            KombinacijeTimova[brojKombinacija].idTim2 = timovi[j].id;
            KombinacijeTimova[brojKombinacija].brojGolova = 0;
            brojKombinacija++;
        }
    }

    for(int i = 0 ; i < brojUtakmica ; i++){
        if(utakmice[i].goloviDomacina > utakmice[i]. goloviGosta) utakmice[i].pobedio = 1;
        if(utakmice[i].goloviDomacina < utakmice[i]. goloviGosta) utakmice[i].pobedio = 2;
    }
    
    for(int i = 0 ; i < brojKombinacija ; i++){
        for (int j = 0 ; j < brojUtakmica ; j++){
            if(KombinacijeTimova[i].idTim1 == utakmice[j].idDomacina && KombinacijeTimova[i].idTim2 == utakmice[j].idGosta){
                if(utakmice[i].pobedio == 1) {
                    KombinacijeTimova[i].pobedaPrvog[KombinacijeTimova[i].brojGolova] = 1;
                    KombinacijeTimova[i].pobedaDrugog[KombinacijeTimova[i].brojGolova] = 0;
                    KombinacijeTimova[i].brojGolova++;
                }
                if(utakmice[i].pobedio == 2) {
                    KombinacijeTimova[i].pobedaPrvog[KombinacijeTimova[i].brojGolova] = 0;
                    KombinacijeTimova[i].pobedaDrugog[KombinacijeTimova[i].brojGolova] = 1;
                    KombinacijeTimova[i].brojGolova++;
                }
            }

            if(KombinacijeTimova[i].idTim1 == utakmice[j].idGosta && KombinacijeTimova[i].idTim2 == utakmice[j].idDomacina){
                if(utakmice[i].pobedio == 1) {
                    KombinacijeTimova[i].pobedaPrvog[KombinacijeTimova[i].brojGolova] = 0;
                    KombinacijeTimova[i].pobedaDrugog[KombinacijeTimova[i].brojGolova] = 1;
                    KombinacijeTimova[i].brojGolova++;
                }
                if(utakmice[i].pobedio == 2) {
                    KombinacijeTimova[i].pobedaPrvog[KombinacijeTimova[i].brojGolova] = 1;
                    KombinacijeTimova[i].pobedaDrugog[KombinacijeTimova[i].brojGolova] = 0;
                    KombinacijeTimova[i].brojGolova++;
                }
            }
        }
    } 

    int maxBroj = -1;
    int timId = -1;
    int timId2 = -1;
    int brojPrvi;
    int brojDrugi;

    for(int i = 0 ; i < brojKombinacija ; i++){
        brojPrvi = 0;
        brojDrugi = 0;
        for(int j = 0 ; j < KombinacijeTimova[i].brojGolova ; j++){
            brojPrvi+= KombinacijeTimova[i].pobedaPrvog[j];
            brojDrugi+=KombinacijeTimova[i].pobedaDrugog[j];
        }

        if(brojPrvi > brojDrugi || brojPrvi == brojDrugi){
            if(brojPrvi > maxBroj) {
            maxBroj = brojPrvi;
            timId = KombinacijeTimova[i].idTim1;
            timId2 = KombinacijeTimova[i].idTim2;}
        }

        if(brojPrvi < brojDrugi){
            if(brojDrugi > maxBroj) {
            maxBroj = brojDrugi;
            timId = KombinacijeTimova[i].idTim2;
            timId2 = KombinacijeTimova[i].idTim1;}
        }
    } 

    char timNaziv[50];
    char timNaziv2[50];
    for(int i = 0 ; i < brojTimova ; i++){
        if(timovi[i].id == timId) strcpy(timNaziv, timovi[i].naziv);
        if(timovi[i].id == timId2) strcpy(timNaziv2, timovi[i].naziv);
    }

    printf("Najvise pobeda tim: %d - %s protiv %s\n", timId, timNaziv, timNaziv2);

    return 1;
}