#!/bin/bash

rm [0-9].csv [0-9].out slurm* 2>/dev/null

INPUT="golovi.csv"
NUM_L=$(wc -l < "$INPUT")
L_PER_F=$((NUM_L/2))
split -l $L_PER_F "$INPUT" in_
i=0
for fajl in in_*
do
    mv "$fajl" "$i.csv"
    ((i+1))
done

gcc -std=c99 -o obradi program.c
chmod +x obradi

NUM_T=$i
ARRAY_RANGE="0-$((NUM_T-1))"

JOB_ID=$(sbatch --array="ARRAY_RANGE" posao.slurm | awk '{print $4}')

while squeue -j $JOB_ID -h | grep -q .
do
    sleep 2
done

OUTPUT="izlaz.txt"
>OUTPUT
cat *.out > $OUTPUT

