from pyspark import SparkContext, SparkConf

def readCsv(path):
    data = sc.textFile(path).map(lambda x: x.split(";"))
    return data

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)

#(ID_utakmice, ID_tima, 1)
golovi = readCsv("./Ulaz/golovi.csv").map(lambda x: (int(x[1]), int(x[2]), 1))
print(golovi.collect())

#(ID_utakmice,ID_domacina,ID_gosta))
utakmice = readCsv("./Ulaz/utakmice.csv").map(lambda x: (int (x[1]), int(x[2]),int(x[3]),0,0))
print(utakmice.collect())

# ((ID_utakmice, ID_tima_koji_je_dao_gol), ID_tima_koji_je_primio)
dati_golovi = utakmice.join(golovi).map(lambda x: ((int (x[0]), int (x[1][0])), int (x[1][1])))
print(dati_golovi.collect())

golovi_prema_istom_timu = dati_golovi.groupByKey(lambda x,y: x==y)
print(golovi_prema_istom_timu.collect())

#raspored hronoloski u fajlu



