from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)


def get_line(line):
    for row in csv.reader([line], delimiter=";"):
        return row


def odredi_rezultat(line):
    
    id_utakmice = line[0]
    id_domacina = line[1][0][0]
    id_gosta = line[1][0][1]

 
    id_tima = line[1][1][0]
    broj_golova = line[1][1][1]

    golovi_dom=0
    golovi_gost=0

    if id_tima !=None:
        if id_tima == id_domacina:
            golovi_dom=broj_golova
        elif id_tima == id_gosta:
            golovi_gost = broj_golova


    return id_utakmice, id_domacina, id_gosta, golovi_dom, golovi_gost


def odredi_pobednika(line):
    id_utakmice = line[0]
    id_domacina = line[1]
    id_gosta = line[2]
    golovi_dom = line[3]
    golovi_gost = line[4]

    if golovi_dom>=golovi_gost:
        return id_utakmice, id_domacina, id_gosta, id_domacina, id_gosta
    else:
        return id_utakmice, id_domacina, id_gosta, id_gosta, id_domacina


timovi = sc.textFile("../timovi.csv").map(get_line)
#print(timovi.take(3))
utakmice = sc.textFile("../utakmice.csv").map(get_line)
#print(utakmice.take(3))
golovi = sc.textFile("../golovi.csv").map(get_line)
#print(golovi.take(3))

timovi_id = timovi.map(lambda r: (r[0], (r[1])))
utakmice_id = utakmice.map(lambda r: (r[0], (r[2], r[3])))
#print(utakmice_id.take(3))
golovi_po_utakmici = golovi.map( lambda r: ((r[1],r[2]), 1))
#print(golovi_po_utakmici.take(3))
golovi_po_utakmici_cnt = golovi_po_utakmici.reduceByKey(lambda a,b: a+b)
#print(golovi_po_utakmici_cnt.take(3))
golovi_po_utakmici_id = golovi_po_utakmici_cnt.map(lambda r: (r[0][0], (r[0][1], r[1])))
golovi_po_utakmici_i_timu_spojeno = utakmice_id.leftOuterJoin(golovi_po_utakmici_id)

golovi_konacni_rezultati = golovi_po_utakmici_i_timu_spojeno.map(odredi_rezultat)


utakmice_pobednici_gubitnici = golovi_konacni_rezultati.map(odredi_pobednika)

utakmice_pobednici_for_gr = utakmice_pobednici_gubitnici.map(lambda r: ((r[3], r[4]), 1))

utakmice_pobednici_sabrano = utakmice_pobednici_for_gr.reduceByKey(lambda a, b: a+b)

utakmice_pobednici_najduze = utakmice_pobednici_sabrano.reduceByKey(lambda a,b: a>b)

pobednik = utakmice_pobednici_najduze.map((r[0][0]), r[1])

tim_pobednik = pobednik.join(timovi_id)

tim_pobednik.asTextFile("pobednik")