# Исписати тим који има најдужу серију победа против истог противника.

from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("resenje")
sc = SparkContext(conf = conf)
sc.setLogLevel("OFF")

def readFromCSV(filePath):
    return sc.textFile(filePath).mapPartitions(lambda x: csv.reader(x, delimiter = ';'))

utakmice = readFromCSV("utakmice.csv")
golovi = readFromCSV("golovi.csv")

# utakmice (id, id_sezone, id_domacina, id_gosta)
# golovi (id, id_utakmice, id_tima, id_igraca)

timovi_protivnici = (
    utakmice.flatMap(lambda x: [
        ((x[0], x[2]), x[3]),
        ((x[0], x[3]), x[2])
    ])
    .partitionBy(4)
    .persist()
)
# timovi_protivnici ((id_utakmice, id_tima), id_protivnika)

# golovi ((id_utakmice, id_tima), id_gola)

gol_razlika = (
    timovi_protivnici
        .join(golovi.map(lambda x: ((x[1], x[2]), x[0])))
        .flatMap(lambda x: [
            ((x[0][0], x[0][1], x[1][0]), 1),
            ((x[0][0], x[1][0], x[0][1]), -1)
        ])
        .reduceByKey(lambda x, y: x + y)
)

# gol_razlika ((id_utakmice, id_tima, id_protivnika), gol_razlika)

pobede = (
    gol_razlika
        .filter(lambda x: x[1] > 0)
        .map(lambda x: ((x[0][1], x[0][2]), x[0][0]))
)
# pobede ((id_tima, id_protivnika), id_utakmice)

broj_uzastopnih_pobeda = (
    pobede
        .mapValues(lambda _ : 1)
        .reduceByKey(lambda x, y: x + y)
        .map(lambda x: (x[0][0], x[0][1], x[1]))
)
# broj_uzastopnih_pobeda ((id_tima, id_protivnika), broj_pobeda)

tim_najduza_serija = (
    broj_uzastopnih_pobeda
    .reduce(lambda x, y: x if x[2] > y[2] else y)
)
# tim_najduza_serija (id_tima, id_protivnika, duzina_serije)

with open("izlaz.txt", "w") as file:
    writer = csv.writer(file, delimiter = ',')
    writer.writerow(tim_najduza_serija)

timovi_protivnici.unpersist()