#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

struct tim {
    int id;
    char naziv[30];
    int protivnici[30]; 
    int pobede[30]; // serija pobeda protiv timova
};

struct utakmica {
    int id;
    int id_sezone;
    int id_domacina;
    int id_gosta;
};

struct gol {
    int id;
    int id_utakmice;
    int id_tima;
    int id_igraca;
};

int u_nizu(int niz[], int id_tima, int broj_protivnika) 
{
    int i;
    for (i = 0; i < broj_protivnika; i++)
    {
        if (niz[i] == id_tima) return i; // vraca niz elementa
    }

    return -1;
}

// Исписати тим који има најдужу серију победа против истог противника.

int main(int argc, char **argv)
{
    struct tim t;

    // promeni na argv[1]
    FILE *f = fopen("Ulaz/timovi.csv", "r");
    if (f == NULL) return 0;

    while ( fscanf(f, "%d;%[^\r\n]", &t.id, t.naziv) == 2 )
    {
        int broj_protivnika = 0;

        // printf("%d %s\n", t.id, t.naziv);

        struct utakmica u;

        // pomocni niz
        int pobede[30];

        FILE *f1 = fopen("Ulaz/utakmice.csv", "r");
        if (f1 == NULL) return 0;

        while ( fscanf(f1, "%d;%d;%d;%d", &u.id, &u.id_sezone, &u.id_domacina, &u.id_gosta) == 4 )
        {
            if (!(t.id == u.id_domacina || t.id == u.id_gosta)) continue;

            int id_protivnika = (t.id == u.id_domacina)? u.id_gosta: u.id_domacina;

            int moji_golovi = 0, golovi_protivnika = 0;

            struct gol g;

            FILE *f2 = fopen("Ulaz/golovi.csv", "r");
            if (f2 == NULL) return 0;

            while ( fscanf(f2, "%d;%d;%d;%d", &g.id, &g.id_utakmice, &g.id_tima, &g.id_igraca) == 4 )
            {
                if (u.id != g.id_utakmice) continue;

                if (t.id == g.id_tima) moji_golovi++;
                else if (id_protivnika == g.id_tima) golovi_protivnika++;


            }
            fclose(f2);

            // printf(" %d-%d:%d-%d\n", t.id, id_protivnika, moji_golovi, golovi_protivnika);


            int indeks = u_nizu(t.protivnici, id_protivnika, broj_protivnika);
            if (indeks == -1) // prvi put igram protiv protivnika
            {
                pobede[broj_protivnika] = 0;

                t.protivnici[broj_protivnika] = id_protivnika;
                t.pobede[broj_protivnika] = 0;

                // ako sam pobedio
                if (moji_golovi > golovi_protivnika) 
                {
                    pobede[broj_protivnika]++;
                    t.pobede[broj_protivnika] = pobede[broj_protivnika];
                }
                
                broj_protivnika++;
            }
            else 
            {
                if (moji_golovi > golovi_protivnika) 
                {
                    pobede[indeks]++;

                    if (pobede[indeks] > t.pobede[indeks]) t.pobede[indeks] = pobede[indeks];
                }
                else 
                {
                    // ako sam izgubio resetujem pobede (pomocni niz)
                    pobede[indeks] = 0;
                }
            }


        }
        fclose(f1);

        // for za ispis pobeda protiv svakog tima todo
        
        // printf(" %d-%d:%d-%d\n", t.id, id_protivnika, moji_golovi, golovi_protivnika);
    }

    fclose(f);

    return 0;
}