from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)

def readFromCSV(path):
    rddCSV = sc.textFile(path).mapPartitions(lambda x: csv.reader(x, delimiter=';'))
    return rddCSV

# Исписати тим који има најдужу серију победа против истог противника.

# 2 tima, idem redom

timovi = readFromCSV("Ulaz/timovi.csv")
utakmice = readFromCSV("Ulaz/utakmice.csv")
golovi = readFromCSV("Ulaz/golovi.csv")

# (id_utakmice, id_tima) -> broj_golova
# map u id_utakmice -> (id_tima, broj_golova)
golovi = golovi.map(
    lambda x: ((x[1], x[2]), 1)
).reduceByKey(lambda x, y: x + y)
# \
#     .map(lambda x: (x[0][0], (x[0][1], x[1])))


# id_utakmice, id_domacina
domacin_utakmice = utakmice.map(
    lambda x: ((x[0], x[2]), 1)
)

# id_utakmice, id_gosta
gost_utakmice = utakmice.map(
    lambda x: ((x[0], x[3]), 1)
)

# id_utakmice, id_tima -> (1, broj_golova (na utakmici) )
# map u id_utakmice -> (id_tima, broj_golova)
domacin_utakmice = domacin_utakmice.leftOuterJoin(golovi)\
    .map(lambda x: (x[0][0], (x[0][1], x[1][1] if x[1][1] != None else 0)))

gost_utakmice = gost_utakmice.leftOuterJoin(golovi)\
    .map(lambda x: (x[0][0], (x[0][1], x[1][1] if x[1][1] != None else 0)))


# id_utakmice -> ((id_tim1, id_tim2), (golovi1, golovi2))
rezultat_utakmice = domacin_utakmice.join(gost_utakmice)\
    .map(lambda x: (x[0], ((x[1][0][0], x[1][1][0]), (x[1][0][1], x[1][1][1])) ))


# Исписати тим који има најдужу серију победа против истог противника.


# (id_tim1, id_tim2) -> golovi1, golovi2
rezultat_utakmice = rezultat_utakmice.map(
    lambda x: ( (x[1][0][0], x[1][0][1]), x[1][1][0], x[1][1][1] )
)

print("=====================")
for p in rezultat_utakmice.collect():
    print(p)
print("=====================")
