from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)

timovi=sc.textFile("timovi.csv") \
    .mapPartitions(lambda x: csv.reader(x,delimiter=';')) \
    .map(lambda x: (x[0],x[1]))

golovi=sc.textFile("golovi.csv") \
    .mapPartitions(lambda x: csv.reader(x,delimiter=';')) \
    .map(lambda x: (x[1],(x[0],x[2]))) #(id_utakmice,(id_gola,id_tima))

utakmice=sc.textFile("utakmice.csv") \
    .mapPartitions(lambda x: csv.reader(x,delimiter=';')) \
    .map(lambda x: ((x[2],x[3]), (x[0],x[1])))

#((id_domaćina, id_gosta),(id, id_sezone))+(i(id_domaćina, id_gosta),(id, id_sezone))=((id_domaćina, id_gosta),((id, id_sezone),(id,id_sezone))
#na koliko razlicitih utakmica su dva ista tima igrala
rez1=utakmice.join(utakmice).filter(lambda x: x[1][0][0]!=x[1][1][0]).map(lambda x: (x[1][0][0],(x[0][0],x[0][1]))) #(id_utakmice,(id_domacina, id_gosta))

#(id_utakmice,(id_domacina, id_gosta))+id_utakmice,(id_gola,id_tima))= (id_utakmice,((id_domacina, id_gosta),(id_gola,id_tima)))
golovi_domacina=rez1.join(golovi).filter(lambda x: x[1][0][0]==x[1][1][1]).map(lambda x: (x[1][0][0],(x[0],x[1][0][1],x[1][1][0],x[1][1][1])))
broj_golova_dom=golovi_domacina.map(lambda x: (x[1][0][0],1)).map(lambda x,y: x+y) #(id_utakmice, broj)

rez2=broj_golova_dom.join(golovi_domacina).map(lambda x: (x[1][1][0], (x[0],x[1][0])))
rez3=rez2.join(rez2).filter(lambda x: x[1][0][0] < x[1][1][0])

print(rez3.collect())

sc.stop()