from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)

# - sve utakmice

utakmiceCSV = sc.textFile("utakmice.csv")
utakmiceRdd = utakmiceCSV.map(lambda l: l.split(";")).map(lambda x : (x[0], x[1], x[2], x[3]))
# - svi golovi

goloviCSV = sc.textFile("golovi.csv")
goloviRdd = goloviCSV.map(lambda l: l.split(";")).map(lambda x : (x[0], x[1], x[2], x[3]))

# - svi timovi

timoviCSV = sc.textFile("timovi.csv")
timoviRdd = timoviCSV.map(lambda l: l.split(";")).map(lambda x: (x[0], x[1]))

# - utakmice i golovi

# ID_UTAKMICE, ID_TIMA - golovi po utakmicamaID
goloviByUtakmice = goloviRdd.map(lambda x: (x[1], x[2]))

# ID_UTAKMICE, ID_DOMACINA, ID_GOSTA - utakmice novi format

utakmice = utakmiceRdd.map(lambda x: (x[0], (x[2], x[3])))

# - ID_UTAKMICE -> ((ID_DOMACINA, ID_GOSTA), ID_TIMA_GOL)
goloviUtakmiceDomaci = utakmice.leftOuterJoin(goloviByUtakmice).filter(lambda x : x[1][1] == x[1][0][0])

goloviUtakmiceGosti = utakmice.leftOuterJoin(goloviByUtakmice).filter(lambda x: x[1][1] == x[1][0][1])

goloviud = goloviUtakmiceDomaci.map(lambda x : (x[0], (x[1][0][0], x[1][0][1], x[1][1])))

goloviug = goloviUtakmiceGosti.map(lambda x : (x[0], (x[1][0][0], x[1][0][1], x[1][1])))

# - po id tima gol
# - kao domacin = ID_TIMA_GOL, ID_UTAKMICE, ID_DOMACIN, ID_GOST
goloviudTemp = goloviud.map(lambda x : (x[1][2], (x[0], x[1][0], x[1][1])))

goloviud_join_tim = goloviud.join(timoviRdd)

goloviud_join_tim = goloviud_join_tim.map(lambda x: (x[1][1], (x[1][0][0], x[1][0][1])))

# - kao gost = ID_TIMA_GOL, ID_UTAKMICE, ID_DOMACIN, ID_GOST
goloviugTemp = goloviug.map(lambda x : (x[1][2], (x[0], x[1][0], x[1][1])))

goloviug_join_tim = goloviug.join(timoviRdd)

goloviug_join_tim = goloviug_join_tim.map(lambda x: (x[1][1], (x[1][0][0], x[1][0][1])))

gud = (goloviud_join_tim.map(lambda x : (x[0], 1)).reduceByKey(lambda a, b : a+b))
gug = (goloviug_join_tim.map(lambda x : (x[0], 1)).reduceByKey(lambda a, b : a+b))

print(gud.collect())
print(gug.collect())

# score = 