#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct tim{
    int id;
    char naziv[100];
    int broj_pobeda;
}tim;

typedef struct utakmica{
    int id;
    int id_sezone;
    int id_domacina;
    int id_gosta;
    int broj_golova_domacina;
    int broj_golova_gosta;
}utakmica;

typedef struct gol{
    int id;
    int id_utakmice;
    int id_tima;
    int id_igraca;
}gol;



int main(int argc, char**argv)
{
    tim timovi[100];
    utakmica utakmice[100];
    gol golovi[100];

    FILE *f;
    f = fopen(argv[1], "r");
    int brojTimova = 0;
    while(fscanf(f,"%d;%[^\n]",&timovi[brojTimova].id, timovi[brojTimova].naziv) == 2)
    {
        timovi[brojTimova].naziv[strlen(timovi[brojTimova].naziv) - 1] = '\0';
        //printf("%d:%s\n", timovi[brojTimova].id, timovi[brojTimova].naziv);
        timovi[brojTimova].broj_pobeda = 0;
        brojTimova++;
    }

    fclose(f);

    //hronoloski gledamo utakmice

    f = fopen("utakmice.csv", "r");
    int brojUtakmica = 0;
    while(fscanf(f,"%d;%d;%d;%d",&utakmice[brojUtakmica].id, &utakmice[brojUtakmica].id_sezone, &utakmice[brojUtakmica].id_domacina, &utakmice[brojUtakmica].id_gosta) == 4)
    {
        //printf("%d;%d;%d;%d\n", utakmice[brojUtakmica].id, utakmice[brojUtakmica].id_sezone, utakmice[brojUtakmica].id_domacina, utakmice[brojUtakmica].id_gosta);
        utakmice[brojUtakmica].broj_golova_domacina = 0;
        utakmice[brojUtakmica].broj_golova_gosta = 0;
        brojUtakmica++;
    }

    fclose(f);

    f = fopen("golovi.csv", "r");
    int brojGolova = 0;
    while(fscanf(f,"%d;%d;%d;%d",&golovi[brojGolova].id, &golovi[brojGolova].id_utakmice, &golovi[brojGolova].id_tima, &golovi[brojGolova].id_igraca) == 4)
    {
        //printf("%d;%d;%d;%d\n", golovi[brojGolova].id, golovi[brojGolova].id_utakmice, golovi[brojGolova].id_tima, golovi[brojGolova].id_igraca);
        brojGolova++;
    }

    fclose(f);

    //printf("==================================================\n");

    for(int i = 0; i<brojUtakmica; i++)
    {
        for(int j = 0; j<brojGolova; j++)
        {
            if(utakmice[i].id == golovi[j].id_utakmice)
            {
                if(utakmice[i].id_domacina == golovi[j].id_tima)
                {
                    utakmice[i].broj_golova_domacina++;
                }
                else if(utakmice[i].id_gosta == golovi[j].id_tima)
                {
                    utakmice[i].broj_golova_gosta++;
                }
            }
        }
        //printf("%d;%d\t%d:%d\n", utakmice[i].id_domacina, utakmice[i].id_gosta, utakmice[i].broj_golova_domacina, utakmice[i].broj_golova_gosta);
    }

    //printf("==================================================\n");

    for(int i = 0; i<brojTimova; i++)
    {
        for(int j = 0; j<brojTimova; j++)
        {
            if(i == j)
            {
                continue;
            }

            int brojPobeda = 0;
            for(int k = 0; k<brojUtakmica;k++)
            {
                if(timovi[i].id == utakmice[k].id_domacina && timovi[j].id == utakmice[k].id_gosta) 
                {
                    if(utakmice[k].broj_golova_domacina > utakmice[k].broj_golova_gosta)
                    {
                        brojPobeda++;
                        if(timovi[i].broj_pobeda < brojPobeda)
                        {
                            timovi[i].broj_pobeda = brojPobeda;
                        }
                    }
                    else{
                        break;
                    }
                }
                else if(timovi[i].id == utakmice[k].id_gosta && timovi[j].id == utakmice[k].id_domacina)
                {
                    if(utakmice[k].broj_golova_gosta > utakmice[k].broj_golova_domacina)
                    {
                        brojPobeda++;
                        if(timovi[i].broj_pobeda < brojPobeda)
                        {
                            timovi[i].broj_pobeda = brojPobeda;
                        }
                    }
                    else{
                        break;
                    }
                }
            }
        }
        printf("%s - broj najvise uzastopnih pobeda protiv istog tima: %d\n", timovi[i].naziv, timovi[i].broj_pobeda);
    }

    return 0;
}