#include<stdio.h>
#include<stdlib.h>

typedef struct timovi{
    int id;
    char naziv[30];
    int najvisePobeda;
}tim;

typedef struct utakmice{
    int id;
    int id_sezone;
    int id_domacina;
    int id_gosta;
}utakmica;

typedef struct golovi{
    int id;
    int id_utakmice;
    int id_tima;
    int id_igraca;
}gol;

int main(int argc, char** argv){
    tim timovi[100];
    utakmica utakmice[100];
    gol golovi[100];

    int brTim = 0;
    int brUtakmice = 0;
    int brGol = 0;

    FILE *f;
    f = fopen("timovi.csv","r");
    printf("TIMOVI: \n");
    while(fscanf(f,"%d;%29[^\n]",&timovi[brTim].id,timovi[brTim].naziv)==2){
        timovi[brTim].najvisePobeda++;
        printf("%d %s\n",timovi[brTim].id,timovi[brTim].naziv);
        brTim++;
    }
    fclose(f);

    f = fopen("utakmice.csv","r");
    printf("UTAKMICE: \n");
    while(fscanf(f,"%d;%d;%d;%d",&utakmice[brUtakmice].id,&utakmice[brUtakmice].id_sezone,&utakmice[brUtakmice].id_domacina,&utakmice[brUtakmice].id_gosta)==4){
        printf("%d %d %d %d\n",utakmice[brUtakmice].id,utakmice[brUtakmice].id_sezone,utakmice[brUtakmice].id_domacina,utakmice[brUtakmice].id_gosta);
        brUtakmice++;
    }
    fclose(f);

    f = fopen("golovi.csv","r");
    printf("GOLOVI: \n");
    while(fscanf(f,"%d;%d;%d;%d",&golovi[brGol].id,&golovi[brGol].id_utakmice,&golovi[brGol].id_tima,&golovi[brGol].id_igraca)==4){
        printf("%d %d %d %d\n",golovi[brGol].id,golovi[brGol].id_utakmice,golovi[brGol].id_tima,golovi[brGol].id_igraca);
        brGol++;
    }
    fclose(f);

    int pobednik[100];
    int gubitnik[100];

    for(int i = 0; i<brUtakmice;i++){
        int goloviDomacina=0;
        int goloviGosta=0;
        for(int j = 0; j<brGol;j++){
            if(utakmice[i].id==golovi[j].id_utakmice){
                if(golovi[j].id_tima==utakmice[i].id_domacina)
                    goloviDomacina++;
                else if(golovi[j].id_tima==utakmice[i].id_gosta)
                    goloviGosta++;
            }
        }      
        if(goloviDomacina>goloviGosta){
            pobednik[i]=utakmice[i].id_domacina;
            gubitnik[i]=utakmice[i].id_gosta;
        }
        else if(goloviGosta>goloviDomacina){
            pobednik[i]=utakmice[i].id_gosta;
            gubitnik[i]=utakmice[i].id_domacina;
        }
    }

    printf("POBEDNICI: \n");
    for(int i = 0; i<brUtakmice;i++){
        printf("%d\n",pobednik[i]);
    }

    printf("GUBITNICI: \n");
    for(int i = 0; i<brUtakmice;i++){
        printf("%d\n",gubitnik[i]);
    }
    

    for(int i = 0; i<brTim;i++){
        int win = 0;
        for(int j = 0; j<brUtakmice;j++){
            if(timovi[i].id==pobednik[j]){
                int pom = 0;
                int w = pobednik[j];
                int l = gubitnik[j];
                for(int k = 0; k < brUtakmice; k++){
                    if(w==pobednik[k] && l==gubitnik[k])
                        pom++;
                }
                if(pom>win)
                    win=pom;
            }
        }
        timovi[i].najvisePobeda=win;
    }

    tim najveciPobednik = timovi[0];
    for (int i = 1; i < brTim; i++){
        if(timovi[i].najvisePobeda>najveciPobednik.najvisePobeda)
            najveciPobednik=timovi[i];
    }
    printf(" Tim sa najduzom serijom pobeda protiv istog protivnika je %s \n",najveciPobednik.naziv);
}
