from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)

def readFromCSV(path):
    rddCSV = sc.textFile(path).mapPartitions(lambda x: csv.reader(x, delimiter=';'))
    return rddCSV

timovi = readFromCSV("timovi.csv") # (idTima, naziv)
utakmice = readFromCSV("utakmice.csv") # (idUtakmice, id_sezone, id_domaćina, id_gosta)
golovi = readFromCSV("golovi.csv") # (idGola, id_utakmice, id_tima, id_igraca)

timovi = timovi.map(lambda x: (x[0], x[1])) #(idTima, naziv)
utakmice = utakmice.map(lambda x: (x[0], (x[2], x[3]))).partitionBy(4).persist() # (idUtakmice, (id_domaćina, id_gosta))
golovi = golovi.map(lambda x: (x[1], (x[0], x[2]))) # (id_utakmice, (idGola, id_tima))

utakmiceGolovi = utakmice.join(golovi) # join = (idUtakmice, ((id_domaćina, id_gosta), (idGola, id_tima)))
utakmiceGoloviDomaci = utakmiceGolovi.filter(lambda x: x[1][0][0] == x[1][1][1]).map(lambda x: ((x[0],x[1][0][0]), 1)).reduceByKey(lambda x, y: x + y).map(lambda x: (x[0][0],(x[0][1], x[1]))) 
                                                                        # map = ((idUtakmice, id_domacina), 1)       # reduce = ((idUtakmice, id_domacina), brGolovaDomacina))  # map = (idUtakmice, (id_domacina, brGolovaDomacina))
utakmiceGoloviGosti = utakmiceGolovi.filter(lambda x: x[1][0][1] == x[1][1][1]).map(lambda x: ((x[0], x[1][0][1]), 1)).reduceByKey(lambda x, y: x + y).map(lambda x: (x[0][0],(x[0][1], x[1])))
                                                                        # map = ((idUtakmice, id_gosta), 1)        # reduce = ((idUtakmice, id_gosta), brGolovaGosta)) # map = (idUtakmice, (id_gosta, brGolovaGosta))
utakmiceRezultati = utakmiceGoloviDomaci.join(utakmiceGoloviGosti)
            # join = (idUtakmice, ((id_domacina, brGolovaDomacina),(id_gosta, brGolovaGosta)))
utakmicePobednikDomacin = utakmiceRezultati.filter(lambda x: x[1][0][1] > x[1][1][1]).map(lambda x: ((x[1][0][0], x[1][1][0]), 1))
                                                                                                     # ((idDomacina, idGosta), 1)
utakmicePobednikGost = utakmiceRezultati.filter(lambda x: x[1][0][1] < x[1][1][1]).map(lambda x: ((x[1][0][0], x[1][1][0]), 1)) 
                                                                                                    # ((idGosta, idDomacina), 1)
pobede = utakmicePobednikDomacin.join(utakmicePobednikGost).reduceByKey(lambda x, y: x + y)                                                                                                    