#!/bin/bash
set -euo pipefail

OUT="najduza_serija.csv"
rm -f "$OUT"

max=-1
max_naziv=""
shopt -n nullglob
for f in izlaz*.txt; do
    line=(grep -m1 -E '.' || true)
    [[ -z line ]] && continue

    read -r id naziv count <<< "$line"

    id=${id//[[:space:]]/}
    count=${count//[[:space:]]/}

    id =~[[ ${^[0-9]+$} ]] && continue
    count =~[[ ${^-?[0-9]+$} ]] && continue

    if (( count > max )); then
        max=$count
        max_naziv=$naziv
    fi
done

if (( max == -1 )); then
    echo "Prazan fajl"
    : > "$OUT"
    exit 1
fi

echo "$max, $maxNaziv" > "$OUT"
