from pyspark import SparkConf, SparkContext
from operator import add
import csv, os, shutil

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)

# (idIgraca, ime)
igraci = (sc.textFile("Ulaz/igraci.csv")
       .mapPartition(lambda x: csv.reader(x, delimiter=';'))
       .map(lambda x: (x[0], x[1]))
)

# (idTima, naziv)
timovi = (sc.textFile("Ulaz/timovi.csv")
       .mapPartition(lambda x: csv.reader(x, delimiter=';'))
       .map(lambda x: (x[0], x[1]))
)

# (idUtakmice, (idSezone, idDomacina, idGosta))
utakmice = (sc.textFile("Ulaz/utakmice.csv")
       .mapPartition(lambda x: csv.reader(x, delimiter=';'))
       .map(lambda x: (x[0], (x[1],x[2],x[3])))
)

# (idGola, (idUtakmice, idTima, idIgraca))
golovi = (sc.textFile("Ulaz/golovi.csv")
       .mapPartition(lambda x: csv.reader(x, delimiter=';'))
       .map(lambda x: (x[0], (x[1],x[2],x[3])))
)

# (idTima, (idUtakmice, idIgraca))
golovi_po_timu = ( golovi
               .map(lambda x: (x[1][1], (x[1][0], x[1][2])))
)

# (idDomacina, (idUtakmice, idSezone, idGosta))
utakmice_domacina = (utakmice
                  .map(lambda x: (x[1][1], (x[0],x[1][0],x[1][2])))
)

# (idDomacina, (idUtakmice, idSezone, idGosta, ukupnoGolova))
golovi_domacina = (utakmice_domacina
                .join(golovi_po_timu)
                .map(lambda x: (x[0], (x[1][0][0], x[1][0][1], x[1][0][2], int(1))))
                .reduceByKey(add)
)

# (idGosta, (idUtakmice, idSezone, idDomacina))
utakmice_gosta = (utakmice
               .map(lambda x: (x[1][2], (x[0],x[1][0],x[1][1])))
)

# (idGosta, (idUtakmice, idSezone, idDomacina, ukupnoGolova))
golovi_gosta = (utakmice_gosta
             .join(golovi_po_timu)
             .map(lambda x: (x[0], (x[1][0][0], x[1][0][1], x[1][0][2], int(1))))
             .reduceByKey(add)
)

sc.stop()